package io.wispforest.accessories.api.data.providers;

import com.mojang.logging.LogUtils;
import org.slf4j.Logger;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2405;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class BaseDataProvider<O extends BaseDataProvider.DataOutput> implements class_2405 {

    protected static final Logger LOGGER = LogUtils.getLogger();

    private final class_7784.class_7489 pathProvider;
    private final CompletableFuture<class_7225.class_7874> registries;

    public BaseDataProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> completableFuture) {
        this.pathProvider = packOutput.method_45973(target(), type());
        this.registries = completableFuture;
    }

    public class_7784.class_7489 pathProvider() {
        return this.pathProvider;
    }

    @Override
    public final CompletableFuture<?> method_10319(class_7403 cachedOutput) {
        return this.registries.thenCompose(provider -> this.run(cachedOutput, provider));
    }

    private CompletableFuture<?> run(class_7403 cachedOutput, class_7225.class_7874 provider) {
        var output = buildOutput(cachedOutput, provider);

        this.buildData(provider, output);

        return CompletableFuture.allOf(output.futures().toArray(CompletableFuture[]::new));
    }

    public abstract String method_10321();

    protected abstract String type();

    protected abstract class_7784.class_7490 target();

    protected abstract O buildOutput(class_7403 cachedOutput, class_7225.class_7874 provider);

    protected abstract void buildData(class_7225.class_7874 provider, O output);

    public interface DataOutput {
        Collection<CompletableFuture<?>> futures();
    }
}
