package io.wispforest.accessories.api.data.providers.entity;

import com.mojang.serialization.Codec;
import io.wispforest.accessories.api.data.providers.BaseDataProvider;
import io.wispforest.owo.serialization.CodecUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class EntityBindingProvider extends BaseDataProvider<EntityBindingProvider.EntityBindingOutput> {

    private final Codec<RawEntityBinding> CODEC = CodecUtils.toCodec(RawEntityBinding.ENDEC);

    public EntityBindingProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> completableFuture) {
        super(packOutput, completableFuture);
    }

    @Override
    protected abstract void buildData(class_7225.class_7874 provider, EntityBindingOutput output);

    public EntityBindingBuilder builder() {
        return new EntityBindingBuilder(false);
    }

    //--

    @Override
    public final String method_10321() {
        return "SlotGroup";
    }

    @Override
    protected final String type() {
        return "accessories/group";
    }

    @Override
    protected final class_7784.class_7490 target() {
        return class_7784.class_7490.field_39367;
    }

    public interface EntityBindingOutput extends BaseDataProvider.DataOutput {
        void accept(class_2960 location, RawEntityBinding binding);
    }

    @Override
    protected EntityBindingOutput buildOutput(class_7403 cachedOutput, class_7225.class_7874 provider) {
        return new EntityBindingOutput() {

            final List<CompletableFuture<?>> list = new ArrayList<>();

            @Override
            public void accept(class_2960 location, RawEntityBinding binding) {
                list.add(class_2405.method_53496(cachedOutput, provider, CODEC, binding, EntityBindingProvider.this.pathProvider().method_44107(location)));
            }

            @Override
            public Collection<CompletableFuture<?>> futures() {
                return List.of();
            }
        };
    }
}
