package io.wispforest.accessories.api.data.providers.group;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import io.wispforest.accessories.api.data.providers.BaseDataProvider;
import io.wispforest.owo.serialization.CodecUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class GroupDataProvider extends BaseDataProvider<GroupDataProvider.GroupOutput> {

    private final Codec<RawSlotGroup> CODEC = CodecUtils.toCodec(RawSlotGroup.ENDEC);

    public GroupDataProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> completableFuture) {
        super(packOutput, completableFuture);
    }

    public interface GroupOutput extends DataOutput {
        void accept(String namespace, RawSlotGroup slotType);
    }

    @Override
    protected abstract void buildData(class_7225.class_7874 provider, GroupOutput output);

    public SlotGroupBuilder builder(class_2960 uniqueLocation) {
        return builder(uniqueLocation.toString());
    }

    public SlotGroupBuilder builder(String groupName) {
        return new SlotGroupBuilder(groupName, false);
    }

    //--

    @Override
    public final String method_10321() {
        return "SlotGroup";
    }

    @Override
    protected final String type() {
        return "accessories/group";
    }

    @Override
    protected final class_7784.class_7490 target() {
        return class_7784.class_7490.field_39367;
    }

    @Override
    protected final GroupOutput buildOutput(class_7403 cachedOutput, class_7225.class_7874 provider) {
        return new GroupOutput() {
            final Set<class_2960> set = Sets.newHashSet();
            final List<CompletableFuture<?>> list = new ArrayList<>();

            @Override
            public void accept(String namespace, RawSlotGroup rawSlotType) {
                var location = class_2960.method_60655(namespace, rawSlotType.name().replace(":", "/"));

                if (!set.add(location)) throw new IllegalStateException("Duplicate Group: " + location);

                list.add(class_2405.method_53496(cachedOutput, provider, CODEC, rawSlotType, GroupDataProvider.this.pathProvider().method_44107(location)));
            }

            @Override
            public Collection<CompletableFuture<?>> futures() {
                return list;
            }
        };
    }
}
