package io.wispforest.accessories.api.data.providers.slot;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import io.wispforest.accessories.api.data.providers.BaseDataProvider;
import io.wispforest.owo.serialization.CodecUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class SlotDataProvider extends BaseDataProvider<SlotDataProvider.SlotOutput> {

    private final Codec<RawSlotType> CODEC = CodecUtils.toCodec(RawSlotType.ENDEC);

    public SlotDataProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> completableFuture) {
        super(packOutput, completableFuture);
    }

    public interface SlotOutput extends DataOutput {
        void accept(String namespace, RawSlotType slotType);
    }

    @Override
    protected abstract void buildData(class_7225.class_7874 provider, SlotOutput output);

    public SlotBuilder builder(class_2960 uniqueLocation) {
        return builder(uniqueLocation.toString());
    }

    public SlotBuilder builder(String slotName) {
        return new SlotBuilder(slotName, false);
    }

    //--

    @Override
    public final String method_10321() {
        return "SlotType";
    }

    @Override
    protected final String type() {
        return "accessories/slot";
    }

    @Override
    protected final class_7784.class_7490 target() {
        return class_7784.class_7490.field_39367;
    }

    @Override
    protected final SlotOutput buildOutput(class_7403 cachedOutput, class_7225.class_7874 provider) {
        return new SlotOutput() {
            final Set<class_2960> set = Sets.newHashSet();
            final List<CompletableFuture<?>> list = new ArrayList<>();

            @Override
            public void accept(String namespace, RawSlotType rawSlotType) {
                var location = class_2960.method_60655(namespace, rawSlotType.name().replace(":", "/"));

                if (!set.add(location)) throw new IllegalStateException("Duplicate SlotType: " + location);

                list.add(class_2405.method_53496(cachedOutput, provider, CODEC, rawSlotType, SlotDataProvider.this.pathProvider().method_44107(location)));
            }

            @Override
            public Collection<CompletableFuture<?>> futures() {
                return list;
            }
        };
    }
}
