package io.wispforest.accessories.api.equip;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import java.util.Optional;
import net.minecraft.class_1799;

/**
 * An action callback to attempt to equip some stack to a given {@link AccessoriesContainer}
 * returned from {@link AccessoriesCapability#canEquipAccessory(class_1799, boolean)} allowing
 * of the ability to equip later once knowing equipability is possible.
 */
public interface EquipAction {

    /**
     * Method used to either equip the given stack or swap the given stack at
     * the location within the action
     *
     * @param stack The given stack to be equipped
     * @return The possible swapped stack if allowing swapping
     */
    Optional<class_1799> equipStack(class_1799 stack);
}
