package io.wispforest.accessories.api.equip;

import io.wispforest.accessories.api.AccessoriesCapability;
import java.util.function.Predicate;
import net.minecraft.class_1792;

/**
 * Controls how {@link AccessoriesCapability} methods handle cosmetic accessories.
 *
 * @see AccessoriesCapability#getFirstEquipped(class_1792, EquipmentChecking)
 * @see AccessoriesCapability#getFirstEquipped(Predicate, EquipmentChecking)
 */
public enum EquipmentChecking {
    /**
     * Only non-cosmetic accessories are considered.
     */
    ACCESSORIES_ONLY,
    /**
     * Cosmetic accessories are preferred over non-cosmetic accessories.
     */
    COSMETICALLY_OVERRIDABLE
}
