package io.wispforest.accessories.api.events;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.api.slot.SlotReference;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

/**
 * Event callback used to allow or denied the ability to adjust a given entities accessories or prevent the Accessory
 * screen being open by the given player.
 * <p>
 * Fired in {@link AccessoriesBasedSlot#method_7674}
 * and in {@link Accessories#openAccessoriesMenu(class_1657, class_1309, class_1799)}
 */
public interface AllowEntityModificationCallback {

    Event<AllowEntityModificationCallback> EVENT = EventFactory.createArrayBacked(AllowEntityModificationCallback.class,
            (invokers) -> (targetEntity, player, reference) -> {
                TriState returnResult = TriState.DEFAULT;

                for (var invoker : invokers) {
                    returnResult = invoker.allowModifications(targetEntity, player, reference);

                    if(!returnResult.equals(TriState.DEFAULT)) break;
                }

                return returnResult;
            }
    );

    /**
     * @param targetEntity The targeted entity for modification
     * @param player       The specific player
     * @param reference    The reference to the specific location within the Accessories Inventory
     * @return If the given player has the ability to modify the given entity
     */
    TriState allowModifications(class_1309 targetEntity, class_1657 player, @Nullable SlotReference reference);
}
