package io.wispforest.accessories.api.events;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.impl.event.AccessoriesEventHandler;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import java.util.List;

/**
 * Event callback used to change if the given entity death will use default accessory behavior to drop
 * the equipped accessories.
 * <p>
 * Fired at {@link AccessoriesEventHandler#onDeath(class_1309, class_1282)}
 */
public interface OnDeathCallback {

    Event<OnDeathCallback> EVENT = EventFactory.createArrayBacked(OnDeathCallback.class,
            (invokers) -> (currentState, entity, capability, damageSource, droppedStacks) -> {
                for (var invoker : invokers) {
                    var returnState = invoker.shouldDrop(currentState, entity, capability, damageSource, droppedStacks);

                    if(returnState != TriState.DEFAULT) currentState = returnState;
                }

                return currentState;
            }
    );

    /**
     * Event used to check if the given default logic for dropping Accessories should be run or not
     *
     * @param currentState Whether someone is attempting to handle the dropping already
     * @param entity The given target entity
     * @param capability The given capability bound to the entity
     * @param damageSource
     * @param droppedStacks
     * @return If default dropping behavior should occur
     */
    TriState shouldDrop(TriState currentState, class_1309 entity, AccessoriesCapability capability, class_1282 damageSource, List<class_1799> droppedStacks);
}
