package io.wispforest.accessories.api.events.extra;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_3489;
import net.minecraft.class_47;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

/**
 * Choice Events implemented for use on {@link Accessory} when needed
 */
public class ExtraEventHandler {

    public static int lootingAdjustments(class_1309 entity, class_47 context, int currentLevel){
        var damageSource = context.method_65013(class_181.field_1231);

        if(damageSource != null && damageSource.method_5529() instanceof class_1309 targetEntity){
            var capability = AccessoriesCapability.get(entity);

            if(capability != null){
                for (var entryRef : capability.getAllEquipped()) {
                    var reference = entryRef.reference();
                    var stack = entryRef.stack();

                    var accessory = AccessoryRegistry.getAccessoryOrDefault(stack);

                    currentLevel += io.wispforest.accessories.api.events.extra.v2.LootingAdjustment.EVENT.invoker().getLootingAdjustment(stack, reference, targetEntity, context, damageSource, currentLevel);

                    //--

                    if(accessory instanceof io.wispforest.accessories.api.events.extra.v2.LootingAdjustment lootingAdjustment){
                        currentLevel += lootingAdjustment.getLootingAdjustment(stack, reference, targetEntity, context, damageSource, currentLevel);
                    }
                }
            }
        }

        return currentLevel;
    }

    public static int fortuneAdjustment(class_47 context, int currentLevel){
        if(context.method_65013(class_181.field_1226) instanceof class_1309 livingEntity) {
            var capability = AccessoriesCapability.get(livingEntity);

            if (capability != null) {
                for (var entryRef : capability.getAllEquipped()) {
                    var reference = entryRef.reference();
                    var stack = entryRef.stack();

                    var accessory = AccessoryRegistry.getAccessoryOrDefault(stack);

                    if (accessory instanceof FortuneAdjustment fortuneAdjustment) {
                        currentLevel += fortuneAdjustment.getFortuneAdjustment(stack, reference, context, currentLevel);
                    }

                    currentLevel += FortuneAdjustment.EVENT.invoker().getFortuneAdjustment(stack, reference, context, currentLevel);
                }
            }
        }

        return currentLevel;
    }

    public static TriState isPiglinsNeutral(class_1309 entity){
        var state = TriState.DEFAULT;

        var capability = AccessoriesCapability.get(entity);

        if(capability != null){
            for (var entryRef : capability.getAllEquipped()) {
                var reference = entryRef.reference();
                var stack = entryRef.stack();

                var accessory = AccessoryRegistry.getAccessoryOrDefault(stack);

                if(accessory instanceof PiglinNeutralInducer inducer){
                    state = inducer.makePiglinsNeutral(stack, reference);

                    if(state != TriState.DEFAULT) return state;
                }

                state = PiglinNeutralInducer.EVENT.invoker().makePiglinsNeutral(stack, reference);

                if(state != TriState.DEFAULT) return state;

                if (stack.method_31573(class_3489.field_54058)) return TriState.TRUE;
            }
        }

        return state;
    }

    public static TriState allowWalkingOnSnow(class_1309 entity){
        var state = TriState.DEFAULT;

        var capability = AccessoriesCapability.get(entity);

        if(capability != null){
            for (var entryRef : capability.getAllEquipped()) {
                var reference = entryRef.reference();
                var stack = entryRef.stack();

                var accessory = AccessoryRegistry.getAccessoryOrDefault(stack);

                if(accessory instanceof AllowWalkingOnSnow event){
                    state = event.allowWalkingOnSnow(stack, reference);

                    if(state != TriState.DEFAULT) return state;
                }

                state = AllowWalkingOnSnow.EVENT.invoker().allowWalkingOnSnow(stack, reference);

                if(state != TriState.DEFAULT) return state;
            }
        }

        return state;
    }

    public static TriState canFreezeEntity(class_1309 entity){
        var state = TriState.DEFAULT;

        var capability = AccessoriesCapability.get(entity);

        if(capability != null){
            for (var entryRef : capability.getAllEquipped()) {
                var reference = entryRef.reference();
                var stack = entryRef.stack();

                var accessory = AccessoryRegistry.getAccessoryOrDefault(stack);

                if(accessory instanceof ShouldFreezeEntity check){
                    state = check.shouldFreeze(stack, reference);

                    if(state != TriState.DEFAULT) return state;
                }

                state = ShouldFreezeEntity.EVENT.invoker().shouldFreeze(stack, reference);

                if(state != TriState.DEFAULT) return state;

                if (stack.method_31573(class_3489.field_28041)) return TriState.FALSE;
            }
        }

        return state;
    }

    //--

    private static final LoadingCache<Integer, Map<Integer, TriState>> gazeDisguiseCache = CacheBuilder.newBuilder()
            .concurrencyLevel(1)
            .expireAfterAccess(Duration.ofSeconds(1))
            //.maximumSize(1000)
            .weakKeys()
            .build(CacheLoader.from(() -> new HashMap<>()));

    public static TriState isGazedBlocked(class_1309 lookingEntity, class_1309 targetEntity){
        if (lookingEntity.method_5864().method_20210(AccessoriesTags.GAZE_DISGUISED_BLACKLIST)) return TriState.DEFAULT;

        var cache = gazeDisguiseCache.getIfPresent(targetEntity.method_5628());

        if(cache != null && cache.containsKey(lookingEntity.method_5628())) return cache.get(lookingEntity.method_5628());

        var state = TriState.DEFAULT;
        var capability = AccessoriesCapability.get(targetEntity);

        if(capability != null) {
            for (var entryRef : capability.getAllEquipped()) {
                var reference = entryRef.reference();
                var stack = entryRef.stack();

                var accessory = AccessoryRegistry.getAccessoryOrDefault(stack);

                if(accessory instanceof IsGazeDisguised masked){
                    state = masked.isWearDisguise(lookingEntity, stack, reference);

                    if(state != TriState.DEFAULT) return state;
                }

                state = IsGazeDisguised.EVENT.invoker().isWearDisguise(lookingEntity, stack, reference);

                if(state != TriState.DEFAULT) return state;

                if (stack.method_31573(class_3489.field_54554)) return TriState.TRUE;
            }
        }

        gazeDisguiseCache.getUnchecked(targetEntity.method_5628())
                .put(lookingEntity.method_5628(), state);

        return state;
    }
}