package io.wispforest.accessories.api.slot;

import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import java.util.function.Predicate;

/**
 * Predicate used to verify if the given stack is valid for the passed SlotType and index
 */
public interface SlotBasedPredicate {

    /**
     * Predicate method used to check if the given stack is valid for the given slot
     *
     * @param level    The current level for the predicate
     * @param slotType The given slot type being checked
     * @param index     The given index being referenced
     * @param stack    The stack being checked
     * @return Whether the stack can be equipped into the given slot
     */
    TriState isValid(class_1937 level, SlotType slotType, int index, class_1799 stack);

    /**
     * @return Predicate that checks solely using the passed stacks item
     */
    static SlotBasedPredicate ofItem(Predicate<class_1792> predicate) {
        return (level, slotType, slot, stack) -> TriState.of(predicate.test(stack.method_7909()));
    }

    /**
     * @return Predicate that checks if the passed {@link class_1792} from the stack is instance of the given {@link Class}
     */
    static <T> SlotBasedPredicate ofClass(Class<T> clazz) {
        return (level, slotType, slot, stack) -> TriState.of(clazz.isInstance(stack.method_7909()));
    }

    static SlotBasedPredicate withEntity(EntityBasedPredicate entityBasedPredicate) {
        return entityBasedPredicate;
    }
}
