package io.wispforest.accessories.api.slot;

import net.minecraft.class_1309;
import net.minecraft.class_1799;

/**
 * Context object holding onto a given slot's reference and a given stack loosely bound to it
 */
public record SlotEntryReference(SlotReference reference, class_1799 stack) implements SlotPathWithStack {

    public SlotEntryReference(class_1309 entity, SlotPath path, class_1799 stack){
        this(SlotReference.of(entity, path), stack);
    }

    @Override
    public SlotPath path() {
        return reference.slotPath();
    }
}
