package io.wispforest.accessories.api.slot;

import io.netty.buffer.ByteBuf;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.bytebuf.ByteBufDeserializer;
import io.wispforest.endec.format.bytebuf.ByteBufSerializer;
import io.wispforest.endec.impl.StructEndecBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import org.jetbrains.annotations.ApiStatus;

/**
 * Helper class allowing for a Serialization of a given SlotReference instance across the network
 */
public class SlotReferenceEncoding {

    /**
     * Encodes the given {@link SlotReference} into the passed {@link ByteBuf} and returns such
     */
    public static ByteBuf encodeReference(ByteBuf byteBuf, SlotReference slotReference) {
        ENDEC.encode(SerializationContext.empty(), ByteBufSerializer.of(byteBuf), slotReference);

        return byteBuf;
    }

    /**
     * Safe method of decoding {@link SlotReference} data from the given {@link ByteBuf} requiring the {@link class_1937} that the
     * entity is located within as a parameter. It is recommended to double-check that the given {@link SlotReference}
     * is still valid using {@link SlotReference#isValid()} as changes may have occurred that invalidates the reference.
     */
    public static SlotReference decodeReference(ByteBuf byteBuf, class_1937 level) {
        return ENDEC.decode(SerializationContext.attributes(new LevelAttribute(level)), ByteBufDeserializer.of(byteBuf));
    }

    //--

    private static final Endec<class_1309> LIVING_ENTITY_ENDEC = Endec.VAR_INT.xmapWithContext(
            (ctx, id) -> {
                var level = ctx.requireAttributeValue(LevelAttribute.LEVEL).level();
                var entity = level.method_8469(id);

                if(entity == null) {
                    throw new IllegalStateException("Unable to locate the given entity with the following ID with the passed level! [Id: " + id + " , Level: " + level.method_27983() + " ]");
                }

                if(!(entity instanceof class_1309 living)) {
                    throw new IllegalStateException("Given entity found within the world was not of LivingEntity! [Id: " + id + ", EntityType: " + entity.method_5864() + ", Level: " + level.method_27983() + " ]");
                }

                return living;
            },
            (context, entity) -> entity.method_5628());

    /**
     * An {@link Endec} for {@link SlotReference} that requires during {@link Endec#encode} or {@link Endec#decode}  that
     * the given {@link SerializationContext} passed within the given method calls requires a
     * {@link LevelAttribute} to properly en(de)code the given reference data
     */
    @ApiStatus.Experimental
    public static final StructEndec<SlotReference> ENDEC = StructEndecBuilder.of(
            LIVING_ENTITY_ENDEC.fieldOf("entity", SlotReference::entity),
            SlotPath.ENDEC.flatFieldOf(SlotReference::slotPath),
            SlotReference::of);

    @ApiStatus.Experimental
    public record LevelAttribute(class_1937 level) implements SerializationAttribute.Instance {
        public static final SerializationAttribute.WithValue<LevelAttribute> LEVEL = SerializationAttribute.withValue("current_minecraft_level");

        @Override public SerializationAttribute attribute() { return LEVEL; }
        @Override public Object value() { return this; }
    }
}
