package io.wispforest.accessories.api.slot;

import io.wispforest.accessories.data.SlotTypeLoader;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;
import net.minecraft.class_1937;

/**
 * Helper Class used to hold a reference for a SlotType to use later if needed
 * with the required context of a level to grab correct side information
 */
public interface SlotTypeReference extends Supplier<String> {

    @Override
    default String get() {
        return slotName();
    }

    String slotName();

    @Nullable
    default SlotType get(boolean isClientSide) {
        if(this.slotName() == null) return null;

        return SlotTypeLoader.INSTANCE.getSlotType(isClientSide, this.slotName());
    }

    @Nullable
    default SlotType get(class_1937 level) {
        return this.get(level.method_8608());
    }
}
