package io.wispforest.accessories.client;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.screen.AccessoriesScreenTransitionHelper;
import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.client.gui.components.AccessoriesScreenSettingsLayout;
import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.client.gui.components.ComponentUtils.CreativeScreenExtension;
import io.wispforest.accessories.compat.config.MenuButtonInjection;
import io.wispforest.accessories.compat.config.client.ExtendedConfigScreen;
import io.wispforest.accessories.compat.config.client.Structured;
import io.wispforest.accessories.compat.config.client.components.StructListOptionContainer;
import io.wispforest.accessories.compat.config.client.components.StructOptionContainer;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.impl.option.PlayerOptions;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.mixin.owo.ConfigWrapperAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.holder.SyncOptionChange;
import io.wispforest.accessories.networking.server.ScreenOpen;
import io.wispforest.endec.impl.ReflectiveEndecBuilder;
import io.wispforest.owo.config.ui.ConfigScreenProviders;
import io.wispforest.owo.config.ui.OptionComponentFactory;
import io.wispforest.owo.config.ui.OptionComponents;
import io.wispforest.owo.config.ui.component.OptionValueProvider;
import io.wispforest.owo.config.ui.component.SearchAnchorComponent;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.*;
import io.wispforest.owo.ui.layers.Layers;
import io.wispforest.owo.util.NumberReflection;
import io.wispforest.owo.util.ReflectionUtils;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1703;
import net.minecraft.class_1746;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

import static io.wispforest.accessories.Accessories.MODID;

import Z;

public class AccessoriesClient {

    public static final class_304.class_11900 KEY_CATEGORY = class_304.class_11900.method_74698(Accessories.of("accessories"));

    public static final class_304 OPEN_SCREEN = new class_304(MODID + ".key.open_accessories_screen", GLFW.GLFW_KEY_H, KEY_CATEGORY);

    //public static final ShaderProgram BLIT_SHADER_KEY = new ShaderProgram(Accessories.of("core/fish"), DefaultVertexFormat.BLIT_SCREEN, ShaderDefines.EMPTY);

    public static final Event<WindowResizeCallback> WINDOW_RESIZE_CALLBACK_EVENT = EventFactory.createArrayBacked(WindowResizeCallback.class, callbacks -> (client, window) -> {
        for (var callback : callbacks) callback.onResized(client, window);
    });

    public static boolean IS_PLAYER_INVISIBLE = false;

    public static void initConfigStuff() {
        ConfigScreenProviders.register(
                Accessories.MODID,
                ExtendedConfigScreen.buildFunc(
                        Accessories.config(),
                        (config, factoryRegister) -> {
                            factoryRegister.registerTypedFactory(AccessoriesPlayerOptionsHolder.class, (model, option) -> {
                                var optionComponent = model.expandTemplate(FlowLayout.class,
                                    "boolean-toggle-config-option",
                                    OptionComponents.packParameters(option.translationKey(), Objects.toString(option.value()))
                                );

                                var holderValue = new MutableObject<>(AccessoriesPlayerOptionsHolder.createOrCopy(option.value()));

                                var resetButton = optionComponent.childById(ButtonComponent.class, "reset-button")
                                    .onPress(button -> {
                                        holderValue.setValue(AccessoriesPlayerOptionsHolder.createOrCopy(option.defaultValue()));
                                        // TODO: ADD RESET FUNCTION
                                        button.field_22763 = false;
                                    });

                                Runnable checkResetButton = () -> resetButton.field_22763 = holderValue.getValue() != null && !holderValue.getValue().isDefaultedValues();

                                checkResetButton.run();

                                var btnLayout = optionComponent.childById(FlowLayout.class, "controls-flow");
                                var tempBtn = optionComponent.childById(ButtonComponent.class, "toggle-button");

                                btnLayout.removeChild(tempBtn);

                                var toggleButton = (ButtonComponent) Components.button(class_2561.method_43470("Edit"), btn -> {})
                                    .verticalSizing(tempBtn.verticalSizing().get())
                                    .horizontalSizing(tempBtn.horizontalSizing().get());

                                btnLayout.child(0, toggleButton);

                                toggleButton.onPress(btn -> {
                                    var currentScreen = class_310.method_1551().field_1755;

                                    var newScreen = new BaseOwoScreen<FlowLayout>() {
                                        @Override
                                        protected @NotNull OwoUIAdapter<FlowLayout> createAdapter() {
                                            return OwoUIAdapter.create(this, Containers::verticalFlow);
                                        }

                                        @Override
                                        protected void build(FlowLayout rootComponent) {
                                            rootComponent.child(
                                                Containers.verticalFlow(Sizing.fixed(178), Sizing.content())
                                                    .child(
                                                        Containers.horizontalFlow(Sizing.content(), Sizing.fixed(14))
                                                            .child(
                                                                Containers.horizontalFlow(Sizing.expand(), Sizing.content())
                                                                    .child(
                                                                        Components.label(
                                                                            class_2561.method_43470("Default Screen Options")
                                                                        )
                                                                    ).horizontalAlignment(HorizontalAlignment.LEFT)
                                                            )
                                                            .child(
                                                                Components.button(class_2561.method_43470("Back"), btn -> method_25419())
                                                                    .verticalSizing(Sizing.fixed(14))
                                                            ).verticalAlignment(VerticalAlignment.CENTER)
                                                    )
                                                    .child(
                                                        Containers.verticalFlow(Sizing.fill(), Sizing.fixed(186))
                                                            .child(new AccessoriesScreenSettingsLayout(holderValue.getValue(), this::component).shouldNetworkSync(false).updateLive(true))
                                                            .padding(Insets.of(1))
                                                            .surface(ComponentUtils.getInsetPanelSurface())
                                                    )
                                                    .gap(3)
                                                    .padding(Insets.of(7))
                                                    .surface(ComponentUtils.getPanelSurface())
                                            );

                                            rootComponent
                                                .surface(Surface.optionsBackground())
                                                .verticalAlignment(VerticalAlignment.CENTER)
                                                .horizontalAlignment(HorizontalAlignment.CENTER);
                                        }

                                        @Override
                                        public void method_25419() {
                                            checkResetButton.run();

                                            class_310.method_1551().method_1507(currentScreen);
                                        }
                                    };
                                    var client = class_310.method_1551();

                                    client.field_1755 = newScreen;
                                    client.field_1755.method_49589();

                                    client.field_1729.method_1610();
                                    class_304.method_1437();
                                    newScreen.method_25423(client, client.method_22683().method_4486(), client.method_22683().method_4502());
                                    client.field_1743 = false;
                                });

                                optionComponent.child(new SearchAnchorComponent(
                                    optionComponent,
                                    option.key(),
                                    () -> optionComponent.childById(LabelComponent.class, "option-name").text().getString(),
                                    () -> toggleButton.method_25369().getString()
                                ));

                                return new OptionComponentFactory.Result<>(optionComponent, new OptionValueProvider() {
                                    @Override public boolean isValid() { return true; }
                                    @Override public Object parsedValue() { return holderValue.getValue(); }
                                });
                            });

                            factoryRegister.registerFactory(
                                    option -> {
                                        var field = option.backingField().field();
                                        if (field.getType() != List.class) return false;

                                        var listType = ReflectionUtils.getTypeArgument(field.getGenericType(), 0);
                                        if (listType == null) return false;

                                        return String.class != listType && !NumberReflection.isNumberType(listType);
                                    },
                                    (uiModel, option) -> {
                                        var layout = new StructListOptionContainer<>(uiModel, option);
                                        return new OptionComponentFactory.Result<>(layout, layout);
                                    });

                            var builder = ((ConfigWrapperAccessor) config).accessories$builder();

                            factoryRegister.registerFactory(
                                    option -> option.backingField().field().isAnnotationPresent(Structured.class),
                                    (model, option) -> {
                                        var annotationData = option.backingField().field().getAnnotation(Structured.class);

                                        var title = net.minecraft.class_2561.method_43471("text.config." + option.configName() + ".option." + option.key().asString());
                                        var titleLayout = Containers.horizontalFlow(Sizing.content(), Sizing.content());
                                        titleLayout.padding(Insets.of(5, 5, 5, 0));

                                        title = title.method_27661().method_27692(class_124.field_1073);
                                        titleLayout.child(Components.label(title));

                                        var component = StructOptionContainer.of(model, option, builder, annotationData.sideBySide());

                                        titleLayout.child(new SearchAnchorComponent(
                                                titleLayout,
                                                option.key(),
                                                () -> class_1074.method_4662("text.config." + option.configName() + ".option." + option.key().asString()),
                                                () -> component.parsedValue().toString()
                                        ));

                                        var mainLayout = Containers.verticalFlow(Sizing.content(), Sizing.content());

                                        mainLayout.child(titleLayout)
                                                .child(component);

                                        return new OptionComponentFactory.Result<io.wispforest.owo.ui.core.Component, OptionValueProvider>(mainLayout, component);
                                    });
                        }));

        Accessories.config().clientOptions.subscribeToEquipControl(value -> {
            attemptAction(holder -> {
                if(holder.getDefaultedData(PlayerOptions.EQUIP_CONTROL) == value) return;

                AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOptions.EQUIP_CONTROL, value));
            });
        });

        Accessories.config().screenOptions.subscribeToShowUnusedSlots(value -> {
            attemptAction(holder -> {
                if(holder.getDefaultedData(PlayerOptions.SHOW_UNUSED_SLOTS) == value) return;

                AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOptions.SHOW_UNUSED_SLOTS, value));
            });
        });

        Accessories.config().screenOptions.subscribeToAlwaysShowCraftingGrid(value -> {
            attemptAction(holder -> {
                if(holder.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID) == value) return;

                AccessoriesNetworking.sendToServer(SyncOptionChange.of(PlayerOptions.SHOW_CRAFTING_GRID, value));
            });
        });
    }

    public static void init(){
        ClientLifecycleEvents.END_DATA_PACK_RELOAD.register((client, success) -> {
            if (!success) return; // LOADING PROBLEM HAS OCCURRED SO THINGS WILL GO WRONG IF WE TRY DOING OUR STUFF

            class_7923.field_41178.forEach(item -> {
                var defaultStack = item.method_7854();

                if (item instanceof class_1746 || defaultStack.method_57826(class_9334.field_54197)) {
                    if (!AccessoriesRendererRegistry.hasRenderer(item)) {
                        // TODO: Replace with better method of targeting only specific slots to disable default rendering
                        AccessoriesRendererRegistry.bindItemToEmptyRenderer(item);
                    }
                }
            });

            AccessoriesRendererRegistry.onReload();
        });

        initLayer();
    }

    public static void openScreenFromKey() {
        var minecraft = class_310.method_1551();
        var currentScreen = minecraft.field_1755;

        if (currentScreen instanceof AccessoriesScreenBase) {
            minecraft.method_1507(null);
        } else if (currentScreen == null) {
            AccessoriesClient.attemptToOpenScreen(minecraft.field_1724.method_5715() ? EntityTarget.LOOKING_ENTITY : EntityTarget.PLAYER);
        } else {
            class_1309 targetEntity = null;

            if (currentScreen instanceof class_465<?> containerScreen) {
                targetEntity = AccessoriesScreenTransitionHelper.getTargetEntity((class_465<class_1703>) containerScreen);
            }

            if (targetEntity == null) targetEntity = minecraft.field_1724;

            AccessoriesClient.attemptToOpenScreenFromEntity(targetEntity);
        }
    }

    private static void attemptAction(Consumer<AccessoriesPlayerOptionsHolder> consumer) {
        var currentPlayer = class_310.method_1551().field_1724;

        if (currentPlayer == null || class_310.method_1551().field_1687 == null) return;

        var options = AccessoriesPlayerOptionsHolder.getOptions(currentPlayer);

        if (options != null) consumer.accept(options);
    }

    public static void initalConfigDataSync() {
        var currentPlayer = class_310.method_1551().field_1724;

        if(currentPlayer == null || class_310.method_1551().field_1687 == null) return;

        var options = AccessoriesPlayerOptionsHolder.getOptions(currentPlayer);

        if(options == null) return;

        var equipControl = Accessories.config().clientOptions.equipControl();

        if(options.getDefaultedData(PlayerOptions.EQUIP_CONTROL) != equipControl) {
            AccessoriesNetworking.sendToServer(PlayerOptions.EQUIP_CONTROL.toPacket(equipControl));
        }

        var showUnusedSlots = Accessories.config().screenOptions.showUnusedSlots();

        if(options.getDefaultedData(PlayerOptions.SHOW_UNUSED_SLOTS) != showUnusedSlots) {
            AccessoriesNetworking.sendToServer(PlayerOptions.SHOW_UNUSED_SLOTS.toPacket(showUnusedSlots));
        }

        var alwaysShowCraftingGrid = Accessories.config().screenOptions.alwaysShowCraftingGrid();

        if(options.getDefaultedData(PlayerOptions.SHOW_CRAFTING_GRID) != alwaysShowCraftingGrid) {
            AccessoriesNetworking.sendToServer(PlayerOptions.SHOW_CRAFTING_GRID.toPacket(true));
        }
    }

    public interface WindowResizeCallback {
        void onResized(class_310 client, class_1041 window);
    }

    private static boolean displayUnusedSlotWarning = false;

    public static boolean attemptToOpenScreen(EntityTarget entityTarget) {
        var player = class_310.method_1551().field_1724;

        class_1309 targetEntity = Accessories.config().screenOptions.keybindIgnoresOtherTargets()
                ? null
                : AccessoriesScreenTransitionHelper.getTargetEntity(player);

        if(targetEntity == null) {
            if (entityTarget.equals(EntityTarget.PLAYER)){
                return attemptToOpenScreenFromEntity(player);
            } else if (entityTarget.equals(EntityTarget.LOOKING_ENTITY)) {
                var result = class_1675.method_49998(player, e -> e instanceof class_1309, player.method_55755());

                if (result instanceof class_3966 entitResult && entitResult.method_17782() instanceof class_1309 living) {
                    targetEntity = living;
                }
            }
        }

        if (targetEntity != null && !EntitySlotLoader.getEntitySlots(targetEntity).isEmpty()) return attemptToOpenScreenFromEntity(targetEntity);

        return false;
    }

    public static boolean attemptToOpenScreenFromEntity(class_1309 targetingEntity) {
        var player = class_310.method_1551().field_1724;

        if(targetingEntity.equals(player)) {
            var slots = AccessoriesCapability.getUsedSlotsFor(player);

            var options = AccessoriesPlayerOptionsHolder.getOptions(player);

            if(slots.isEmpty() && !options.getDefaultedData(PlayerOptions.SHOW_UNUSED_SLOTS) && !displayUnusedSlotWarning && !Accessories.config().clientOptions.disableEmptySlotScreenError()) {
                player.method_7353(class_2561.method_43470("[Accessories]: No Used Slots found by any mod directly, the screen will show empty unless a item is found to implement slots!"), false);

                displayUnusedSlotWarning = true;
            }
        }

        var selectedVariant = AccessoriesMenuVariant.PRIMARY_V2;

        class_1799 creativeCarriedStack = (class_310.method_1551().field_1755 instanceof class_481 screen)
                ? screen.method_17577().method_34255()
                : null;

        AccessoriesNetworking.sendToServer(ScreenOpen.of(targetingEntity, selectedVariant, creativeCarriedStack));

        return true;
    }

    public static void attemptToOpenSelectionScreen(int entityId, boolean targetLookEntity, class_1657 player) {
        var selectedVariant = AccessoriesMenuVariant.PRIMARY_V2;

        class_1799 creativeCarriedStack = (class_310.method_1551().field_1755 instanceof class_481 screen)
            ? screen.method_17577().method_34255()
            : null;

        Function<AccessoriesMenuVariant, ScreenOpen> packetBuilder = (menuVariant) -> {
            return new ScreenOpen(targetLookEntity ? -1 : entityId, targetLookEntity, menuVariant, creativeCarriedStack);
        };

        AccessoriesNetworking.sendToServer(packetBuilder.apply(selectedVariant));
    }

    //--

    public static void initLayer() {
        AccessoriesScreenTransitionHelper.init();

        Layers.add(Containers::verticalFlow, instance -> {
            // THIS IS HERE TO HAVE UPDATE POSITION EVERY FRAME BEFORE RENDER TO STOP STUPID POSITIONING PROBLEMS!!!
            instance.aggressivePositioning = true;

            instance.adapter.rootComponent.allowOverflow(true);

            var injectionData = AccessoriesScreenTransitionHelper.getInjection(instance.screen);

            if (injectionData == null) return;

            var button = (ButtonComponent) Components.button(class_2561.method_43470(""), (btn) -> {
                        var target = AccessoriesScreenTransitionHelper.getTargetEntity(instance.screen);

                        if (target == null) target = class_310.method_1551().field_1724;

                        AccessoriesClient.attemptToOpenScreenFromEntity(target);
                    })
                    .renderer((context, btn, delta) -> {
                        DrawUtils.blit(context,
                                Accessories.of("textures/gui/accessories_open_icon" + (btn.method_49606() ? "_hovered" : "") + ".png"),
                                btn.x(), btn.y(), 0, 0, 8, 8, 8, 8
                        );
                    })
                    .tooltip(class_2561.method_43471(Accessories.translationKey("open.screen")))
                    .margins(Insets.of(1, 0, 0, 1))
                    .sizing(Sizing.fixed(8));

            if(instance.screen instanceof class_481){
                var extension = ((ComponentUtils.CreativeScreenExtension) instance.screen);

                button.field_22764 = extension.getTab().method_47312().equals(class_1761.class_7916.field_41053);

                extension.getEvent().register(tab -> button.field_22764 = tab.method_47312().equals(class_1761.class_7916.field_41053));
            }

            instance.adapter.rootComponent.child(button);

            instance.alignComponentToHandledScreenCoordinates(button, injectionData.xOffset(), injectionData.yOffset());

        }, AccessoriesScreenTransitionHelper.getScreenClasses());
    }
}
