package io.wispforest.accessories.client;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.wispforest.accessories.Accessories;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.OwoUIPipelines;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4668;
import net.minecraft.class_6367;

public class AccessoriesPipelines {

    public static final class_1921.class_4687 HSV_GUI = class_1921.method_24048(
            "accessories:hsv_gui",
            786432,
            OwoUIPipelines.GUI_HSV,
            class_1921.class_4688.method_23598().method_23617(false)
    );

    public static final RenderPipeline.Snippet SPECTRUM_SNIPPET = RenderPipeline.builder(class_10799.field_60125)
            .withFragmentShader(Accessories.of("core/spectrum_position_tex"))
            .withVertexShader(Accessories.of("core/spectrum_position_tex"))
            .withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27382)
            .withBlend(BlendFunction.TRANSLUCENT)
            .withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST)
            .withSampler("InputSampler")
            .buildSnippet();

    public static final RenderPipeline SPECTRUM = RenderPipeline.builder(SPECTRUM_SNIPPET)
            .withLocation(Accessories.of("pipeline/spectrum"))
            .build();

    public static final Function<class_2960, class_1921> SPECTRUM_GUI = class_156.method_34866(
            resourceLocation -> class_1921.method_24048(
                    "accessories:spectrum_gui",
                    786432,
                    SPECTRUM,
                    class_1921.class_4688.method_23598()
                            .method_34577(new class_4668.class_4683(resourceLocation, false))
                            .method_23617(false)
            )
    );

    public static final RenderPipeline COLORED_GUI_TEXTURED_PIPE = RenderPipeline.builder(class_10799.field_56864)
            .withLocation(Accessories.of("pipeline/colored_gui_textured"))
            .withColorWrite(true)
            .withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST)
            .withBlend(new BlendFunction(SourceFactor.ONE, DestFactor.ONE))
            .build();

    public static final BiFunction<Color, class_2960, class_1921> COLORED_GUI_TEXTURED = class_156.method_34865(
            (color, resourceLocation) -> {
                return class_1921.method_24048(
                        "accessories:colored_gui_textured",
                        786432,
                        COLORED_GUI_TEXTURED_PIPE,
                        class_1921.class_4688.method_23598()
                                .method_34577(new class_4668.class_4683(resourceLocation, false))
                                /*.setTexturingState(new RenderStateShard.TexturingStateShard("setting_shader_color", () -> {
                                    RenderSystem.setShaderColor(color.red(), color.green(), color.blue(), 1f);
                                }, () -> {
                                    RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
                                }))*/
                                .method_23617(false));
            }
    );

    public static void registerPipelines(Consumer<RenderPipeline> pipelineRegister) {
        pipelineRegister.accept(SPECTRUM);
        pipelineRegister.accept(COLORED_GUI_TEXTURED_PIPE);
    }

    private static class_6367 BUFFER = null;

    private static Color SHADER_COLOR = null;
    // TODO: FIX THIS WHEN WE CARE ENOUGH TO RESOLVE ISSUES
//    private static final RenderType HOVER_EFFECT = RenderType.create(
//        "accessories_hover_effect",
//        786432,
//        RenderPipelines.GUI_TEXTURED_OVERLAY,
//        RenderType.CompositeState.builder().setTextureState(new RenderStateShard.EmptyTextureStateShard(
//            () -> {
//                RenderSystem.setShaderTexture(0, getOrCreateBuffer().getColorTexture());
//                if (SHADER_COLOR != null) {
//                    RenderSystem.setShaderColor(SHADER_COLOR.red(), SHADER_COLOR.green(), SHADER_COLOR.blue(), SHADER_COLOR.alpha());
//                }
//            },
//            () -> {
//                if (SHADER_COLOR != null) {
//                    RenderSystem.setShaderColor(1, 1, 1, 1);
//                    SHADER_COLOR = null;
//                }
//            }
//        )).createCompositeState(false)
//    );

//    public static RenderType setupHoverEffect(Color color) {
//        SHADER_COLOR = color;
//
//        return HOVER_EFFECT;
//    }

    public static class_6367 getOrCreateBuffer() {
        try {
            if (BUFFER == null) {
                var window = class_310.method_1551().method_22683();

                BUFFER = new class_6367("accessories_buffer_thingy", window.method_4489(), window.method_4506(), true);

                WindowResizeCallback.EVENT.register((innerClient, innerWindow) -> {
                    if (BUFFER == null) return;
                    BUFFER.method_1234(innerWindow.method_4489(), innerWindow.method_4506());
                });
            }
        } catch (Exception e) {
            throw new IllegalStateException("Unable to create the buffer for Accessories Hover Rendering due to an error!", e);
        }

        return BUFFER;
    }
}
