package io.wispforest.accessories.client;

import F;
import J;
import Z;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.AccessoriesRenderStateKeys;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.client.gui.AccessoriesScreenBase;
import io.wispforest.accessories.compat.config.AccessoriesConfig.ScreenOptions_.HoveredOptions_;
import io.wispforest.accessories.compat.config.AccessoriesConfig.ScreenOptions_.UnHoveredOptions_;
import io.wispforest.accessories.menu.AccessoriesInternalSlot;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_10042;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_11659;
import net.minecraft.class_11890;
import net.minecraft.class_11901;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_746;
import net.minecraft.class_922;


/**
 * Render layer used to render equipped Accessories for a given {@link class_1309}.
 * This is only applied to {@link class_922} that have a model that
 * extends {@link class_572}
 */
public class AccessoriesRenderLayer<S extends class_10042, M extends class_583<S>> extends class_3887<S, M> {

    private static final float increment = 0.1f;

    private static final Map<SlotPath, Float> brightnessMap = new HashMap<>();
    private static final Map<SlotPath, Float> opacityMap = new HashMap<>();

    private static long lastUpdated20th = 0;

    public AccessoriesRenderLayer(class_3883<S, M> renderLayerParent) {
        super(renderLayerParent);
    }

    @Override
    public void submit(class_4587 poseStack, class_11659 submitNodeCollector, int light, S entityState, float f, float g) {
        var client = class_310.method_1551();

        var states = entityState.getStateData(AccessoriesRenderStateKeys.ACCESSORY_RENDER_STATES);

        if (states == null) return;

        entityState.setStateData(AccessoriesRenderStateKeys.LIGHT, light);

        var funkyRenderState = AccessoriesFunkyRenderingState.INSTANCE;
        
        var isRenderingLineTarget = funkyRenderState.isIsRenderingLineTarget();

        var renderingLines = funkyRenderState.isCollectAccessoryPositions();
        var positions = funkyRenderState.getNotVeryNicePositions();

        if (!renderingLines && !positions.isEmpty()) {
            positions.clear();
        }
        
//        var useCustomerBuffer = funkyRenderState.isIsRenderingUiEntity();
//
//        if (useCustomerBuffer && multiBufferSource instanceof MultiBufferSource.BufferSource bufferSource) {
//            bufferSource.endBatch();
//        }

        var scale = (float) (1 + (0.5 * (0.75 + (Math.sin((System.currentTimeMillis()) / 250d)))));

        var calendar = Calendar.getInstance();

        var current20th = calendar.getTimeInMillis() / 50;

        var shouldUpdate = lastUpdated20th != current20th;
        if (shouldUpdate) lastUpdated20th = current20th;

        var selected = (client.field_1755 instanceof AccessoriesScreenBase<?> screenBase)
            ? screenBase.getSelectedSlotIf(AccessoriesInternalSlot.class)
            : null;

        boolean preventHovering = selected != null && selected.method_7677().method_7960();

        var unHoveredOptions = Accessories.config().screenOptions.unHoveredOptions;
        var hoveredOptions = Accessories.config().screenOptions.hoveredOptions;

        var isFunnyDate = calendar.get(Calendar.MONTH) + 1 == 5 && calendar.get(Calendar.DATE) == 16;

        var selectedPath = selected != null ? selected.slotPath() : null;

        states.forEach((path, accessoryRenderState) -> {
            var isSelected = path.equals(selectedPath);

            if (shouldUpdate) {
                var currentBrightness = brightnessMap.getOrDefault(path, 1f);
                var currentOpacity = opacityMap.getOrDefault(path, 1f);

                if (selectedPath != null && !isSelected && !preventHovering) {
                    brightnessMap.put(path, Math.max(unHoveredOptions.darkenedBrightness(), currentBrightness - increment));
                    opacityMap.put(path, Math.max(unHoveredOptions.darkenedOpacity(), currentOpacity - increment));
                } else {
                    brightnessMap.put(path, Math.min(1, currentBrightness + increment));
                    opacityMap.put(path, Math.min(1, currentOpacity + increment));
                }
            }

            var stack = accessoryRenderState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
            var renderer = AccessoriesRendererRegistry.getRenderer(stack);

//            var mpoatv = new MPOATVConstructingVertexConsumer();
//
//            var bufferedGrabbedFlag = new MutableBoolean(false);
//
//            MultiBufferSource innerBufferSource = (renderType) -> {
//                bufferedGrabbedFlag.setValue(true);
//
//                return useCustomerBuffer ?
//                    VertexMultiConsumer.create(multiBufferSource.getBuffer(renderType), mpoatv) :
//                    multiBufferSource.getBuffer(renderType);
//            };

            if (/*!useCustomerBuffer || */isSelected || selectedPath == null || unHoveredOptions.renderUnHovered()) {
                poseStack.method_22903();

                try {
                    renderer.render(accessoryRenderState, entityState, method_17165(), poseStack, submitNodeCollector);
                } catch (Throwable e) {
                    AccessoryRendererErrorCache.logIfTimeAllotted(entityState.getEntityUUIDForState(), stack, renderer, e);
                }

                poseStack.method_22909();
            }

            // Code area for handling the hovering effect that makes such items on the entity glow if within a screen for such
//            if (useCustomerBuffer && bufferedGrabbedFlag.getValue()) {
//                if (multiBufferSource instanceof MultiBufferSource.BufferSource bufferSource) {
//                    Color shaderColor = null;
//
//                    if (hoveredOptions.brightenHovered() && isSelected) {
//                        if (isFunnyDate) {
//                            var hue = (float) ((System.currentTimeMillis() / 20d % 360d) / 360d);
//                            shaderColor = Color.ofHsv(hue, 1, 1);
//                        } else {
//                            var mul = hoveredOptions.cycleBrightness() ? scale : 1.5f;
//                            shaderColor = new Color(mul, mul, mul, 1);
//                        }
//                    } else if (unHoveredOptions.darkenUnHovered()) {
//                        var darkness = brightnessMap.getOrDefault(mapKey, 1f);
//
//                        shaderColor = new Color(darkness, darkness, darkness, opacityMap.getOrDefault(mapKey, 1f));
//                    }
//
//                    if (shaderColor != null) {
//                        var encoder = RenderSystem.getDevice().createCommandEncoder();
//                        var main = client.getMainRenderTarget();
//                        var buffer = AccessoriesPipelines.getOrCreateBuffer();
//
//                        encoder.copyTextureToTexture(main.getDepthTexture(), buffer.getDepthTexture(), 0, 0, 0, 0, 0, buffer.width, buffer.height);
//                        encoder.clearColorTexture(buffer.getColorTexture(), 0);
//
//                        funkyRenderState.wrapBufferManipulation(bufferSource::endBatch);
//
//                        var window = client.getWindow();
//
//                        var x2 = window.getGuiScaledWidth();
//                        var y2 = window.getGuiScaledHeight();
//
////                            bufferSource.getBuffer(AccessoriesPipelines.setupHoverEffect(shaderColor))
////                                .addVertex(0, 0, 0).setUv(0, 1).setColor(0xffffffff)
////                                .addVertex(0, y2, 0).setUv(0, 0).setColor(0xffffffff)
////                                .addVertex(x2, y2, 0).setUv(1, 0).setColor(0xffffffff)
////                                .addVertex(x2, 0, 0).setUv(1, 1).setColor(0xffffffff);
//                    }
//
//                    bufferSource.endBatch();
//                }
//            }

//            if (renderingLines && isRenderingLineTarget) {
//                var pos = mpoatv.meanPos();
//
//                if (pos != null) positions.put(path, pos);
//            }
        });
    }

    public static <A extends class_11890 & class_11901> void submitFirstPersonAsClientPlayer(class_1007<A> avatarRender, class_572<class_10055> model, class_4587 matrices, int combinedLight, class_11659 submitNodeCollector, class_1306 arm) {
        var player = class_310.method_1551().field_1724;

        submitFirstPerson(player, (class_1007) avatarRender, model, matrices, combinedLight, submitNodeCollector, arm);
    }

    public static <A extends class_11890 & class_11901> void submitFirstPerson(A entity, class_1007<A> avatarRender, class_572<class_10055> model, class_4587 matrices, int combinedLight, class_11659 submitNodeCollector, class_1306 arm) {
        var level = entity.method_73183();

        var partialTicks = class_310.method_1551().method_61966().method_60637(!level.method_54719().method_54746(entity));

        var entityState = avatarRender.method_62425(entity, partialTicks);

        entityState.setStateData(AccessoriesRenderStateKeys.LIGHT, combinedLight);

        AccessoriesRenderStateKeys.setupStateForAccessories(entityState, entity, partialTicks, arm);

        var states = entityState.getStateData(AccessoriesRenderStateKeys.ACCESSORY_RENDER_STATES);

        if (states == null) return;

        states.forEach((slotPath, accessoryRenderState) -> {
            matrices.method_22903();

            var stack = accessoryRenderState.getStateData(AccessoriesRenderStateKeys.ITEM_STACK);
            var renderer = AccessoriesRendererRegistry.getRenderer(stack);

            try {
                renderer.render(accessoryRenderState, entityState, model, matrices, submitNodeCollector);
            } catch (Throwable e) {
                AccessoryRendererErrorCache.logIfTimeAllotted(entityState.getEntityUUIDForState(), stack, renderer, e);
            }

            matrices.method_22909();
        });
    }

}
