package io.wispforest.accessories.client;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.renderers.AccessoryRenderer;
import org.slf4j.Logger;

import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class AccessoryRendererErrorCache {
    private static final ClientDelayedCache<Key> ERROR_CACHE = new ClientDelayedCache<>(4000);

    private static final Logger LOGGER = LogUtils.getLogger();

    public static void logIfTimeAllotted(UUID uuid, class_1799 stack, AccessoryRenderer renderer, Throwable e) {
        var key = new Key(uuid, class_1799.method_57355(stack), AccessoriesRendererRegistry.getRendererId(renderer));

        // TODO: Maybe also send a toast???
        if (ERROR_CACHE.hasAllottedTime(key, 10)) {
            LOGGER.error("[AccessoryRendererError] Unable to use the given Renderer [{}] to render the given item [{}] for UUID [{}] due to the given error: ", key.rendererId(), stack, uuid, e);
        }
    }

    public record Key(UUID entityUUID, int itemStackHash, class_2960 rendererId) { }
}
