package io.wispforest.accessories.client;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_4588;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Vector4f;

public record BlitSpectrumRenderState(
    RenderPipeline pipeline,
    class_11231 textureSetup,
    Matrix3x2f pose,
    int x0,
    int y0,
    int x1,
    int y1,
    float u0,
    float u1,
    float v0,
    float v1,
    Vector4f alphaValues,
    @Nullable class_8030 scissorArea,
    @Nullable class_8030 bounds
) implements class_11244 {
    public BlitSpectrumRenderState(
        RenderPipeline pipeline,
        class_11231 textureSetup,
        Matrix3x2f pose,
        int x0,
        int y0,
        int x1,
        int y1,
        float u0,
        float u1,
        float v0,
        float v1,
        Vector4f alphaValues,
        @Nullable class_8030 scissorArea
    ) {
        this(pipeline, textureSetup, pose, x0, y0, x1, y1, u0, u1, v0, v1, alphaValues, scissorArea, getBounds(x0, y0, x1, y1, pose, scissorArea));
    }

    @Override
    public void method_70917(class_4588 vertexConsumer) {
        vertexConsumer.method_70815(this.pose(), this.x0(), this.y0()).method_22913(this.u0(), this.v0()).method_22915(1.0f, 1.0f, 1.0f, alphaValues.x);
        vertexConsumer.method_70815(this.pose(), this.x0(), this.y1()).method_22913(this.u0(), this.v1()).method_22915(0, 1.0f, 1.0f, alphaValues.z);
        vertexConsumer.method_70815(this.pose(), this.x1(), this.y1()).method_22913(this.u1(), this.v1()).method_22915(0, 1.0f, 1.0f, alphaValues.w);
        vertexConsumer.method_70815(this.pose(), this.x1(), this.y0()).method_22913(this.u1(), this.v0()).method_22915(1.0f, 1.0f, 1.0f, alphaValues.y);
    }

    @Nullable
    private static class_8030 getBounds(int i, int j, int k, int l, Matrix3x2f matrix3x2f, @Nullable class_8030 screenRectangle) {
        class_8030 screenRectangle2 = new class_8030(i, j, k - i, l - j).method_71523(matrix3x2f);
        return screenRectangle != null ? screenRectangle.method_49701(screenRectangle2) : screenRectangle2;
    }
}
