package io.wispforest.accessories.client;

import F;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.OwoUIPipelines;
import io.wispforest.owo.ui.renderstate.GradientQuadElementRenderState;
import net.minecraft.class_1058;
import net.minecraft.class_10725;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8030;
import org.joml.Matrix3x2f;
import org.joml.Vector4f;

public class DrawUtils {

    public static void drawWithSpectrum(class_332 ctx, int x, int y, int blitOffset, int width, int height, class_2960 texture, float alpha) {
        class_1058 sprite = class_310.method_1551().method_72703()
            .method_73025(class_10725.field_56385)
            .method_4608(texture);

        innerDrawWithSpectrum(ctx, sprite.method_45852(), x, x + width, y, y + height, blitOffset, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575(), new Vector4f(alpha));
    }

    public static void drawWithSpectrum(class_332 ctx, int x, int y, int blitOffset, int width, int height, class_1058 sprite, float alpha) {
        innerDrawWithSpectrum(ctx, sprite.method_45852(), x, x + width, y, y + height, blitOffset, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575(), new Vector4f(alpha));
    }

    public static void drawWithSpectrum(class_332 ctx, int x, int y, int blitOffset, int width, int height, class_1058 sprite, Vector4f alphaValues) {
        innerDrawWithSpectrum(ctx, sprite.method_45852(), x, x + width, y, y + height, blitOffset, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575(), alphaValues);
    }

    // X: Top Left
    // Y: Top Right
    // Z: Bottom Left
    // W: Bottom Right
    private static void innerDrawWithSpectrum(class_332 guiGraphics, class_2960 atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, Vector4f alphaValues) {
        guiGraphics.field_59826.method_70919(
            new BlitSpectrumRenderState(
                AccessoriesPipelines.SPECTRUM,
                class_11231.method_70899(),
                new Matrix3x2f(guiGraphics.method_51448()),
                x1, y1, x2, y2,
                minU, maxU,
                minV, maxV,
                alphaValues,
                guiGraphics.field_44659.method_70863()
            )
        );
    }

    public static void drawRectOutlineWithSpectrum(OwoUIDrawContext ctx, int x, int y, int width, int height, float alpha, boolean vertical) {
        innerFill(ctx, x, y, width, 1, alpha, !vertical);
        innerFill(ctx, x, y + height - 1, width, 1, alpha, !vertical);

        innerFill(ctx, x, y + 1, 1, height - 2, alpha, vertical);
        innerFill(ctx, x + width - 1, y + 1, 1, height - 2, alpha, vertical);
    }

    private static void innerFill(class_332 guiGraphics, int x, int y, int width, int height, float alpha, boolean vertical) {
        var multiplier = (float) ((System.currentTimeMillis() / 20d % 360d) / 360d);

        var topValue = 1f - multiplier;
        var bottomValue = topValue; //0f + multiplier;

        var matrix = new Matrix3x2f(guiGraphics.method_51448());
        var scissorRect = guiGraphics.field_44659.method_70863();

        // TODO: SEEMS BROKEN WHEN ANYTHING IS MANIPULATION THE MATRIX STACK SOOOOOO
        guiGraphics.field_59826.method_70919(
            new GradientQuadElementRenderState(
                OwoUIPipelines.GUI_HSV,
                matrix,
                new class_8030(x, y, width, height).method_71523(matrix),
                scissorRect,
                new Color(topValue, 1f, 1f, alpha),
                new Color(bottomValue, 1f, 1f, alpha),
                new Color(vertical ? bottomValue : topValue, 1f, 1f, alpha),
                new Color(vertical ? topValue : bottomValue, 1f, 1f, alpha)
            )
        );
    }

    private static class_8030 getBounds(int x1, int y1, int x2, int y2, Matrix3x2f matrix3x2f) {
        return new class_8030(x1, y1, Math.abs(x2 - x1), Math.abs(y2 - y1))/*.transformMaxBounds(matrix3x2f)*/;
    }

    public static void blitSprite(class_332 context, class_2960 atlasLocation, int x, int y, int width, int height) {
        blitSprite(context, atlasLocation, x, y, width, height, -1);
    }

    public static void blitSprite(class_332 context, class_2960 atlasLocation, int x, int y, int width, int height, int blitOffset) {
        context.method_52707(class_10799.field_56883, atlasLocation, x, y, width, height, blitOffset);
    }

    public static void blit(class_332 context, class_2960 atlasLocation, int x, int y, int width, int height) {
        blit(context, atlasLocation, x, y, 0, 0, width, height, width, height);
    }

    public static void blit(class_332 context, class_2960 atlasLocation, int x, int y, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        blit(context, atlasLocation, x, y, 0, 0, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static void blit(class_332 context, class_2960 atlasLocation, int x, int y, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        context.method_25302(class_10799.field_56883, atlasLocation, x, y, uOffset, vOffset, uWidth, vHeight, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static void blit(class_332 context, class_2960 atlasLocation, int x, int y, float uOffset, float vOffset, int uWidth, int vHeight, int width, int height, int textureWidth, int textureHeight) {
        context.method_25293(class_10799.field_56883, atlasLocation, x, y, uOffset, vOffset, uWidth, vHeight, width, height, textureWidth, textureHeight, -1);
    }

    // TODO: THIS CURRENTLY DOSE NOT MAKE THE ICONS WHITE AT ALL AND REQUIRES HEAVY MODIFICATION SIMILAR TO OWO BLUR TO SETUP THE UNIFORMS CORRECTLY
    public static void blitSpriteWithColor(class_332 context, class_1058 sprite, int x, int y, int width, int height, Color color) {
        context.method_52710(class_10799.field_56883/*location -> AccessoriesPipelines.COLORED_GUI_TEXTURED.apply(color, location)*/, sprite, x, y, width, height, color.argb());
    }
}
