package io.wispforest.accessories.client.gui;

import io.wispforest.accessories.impl.option.PlayerOption;
import io.wispforest.accessories.menu.SlotTypeAccessible;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.server.ContainerClose;
import io.wispforest.accessories.pond.CloseContainerTransfer;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_3936;
import net.minecraft.class_490;
import net.minecraft.class_746;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public interface AccessoriesScreenBase<M extends AccessoriesMenuBase> extends class_3936<M> {

    //--

    MutableBoolean FORCE_TOOLTIP_LEFT = new MutableBoolean(false);

    //--

    void onHolderChange(PlayerOption<?> option);

    @Nullable
    SlotTypeAccessible getSelectedSlot();

    @Nullable
    default <S extends SlotTypeAccessible> S getSelectedSlotIf(Class<S> clazz){
        var slot = getSelectedSlot();

        if (slot == null) return null;

        return clazz.isInstance(slot) ? (S) slot : null;
    }

    default class_1309 targetEntityDefaulted() {
        var targetEntity = this.method_17577().targetEntity();

        return (targetEntity != null) ? targetEntity : class_310.method_1551().field_1724;
    }

    default void switchToBaseInventory() {
        this.method_17577().transferAndClose(() -> {
            var player = class_310.method_1551().field_1724;

            ((CloseContainerTransfer) player).accessories$setScreenTransfer(new class_490(player));
            player.method_7346();
            AccessoriesNetworking.sendToServer(new ContainerClose());
        });
    }
}
