package io.wispforest.accessories.client.gui;

import Z;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.server.SyncCosmeticToggle;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_11907;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import net.minecraft.class_9848;

public class ToggleButton extends class_4185 {

    private static final class_8666 SPRITES = new class_8666(
            class_2960.method_60656("widget/button"),
            class_2960.method_60656("widget/button_disabled"),
            class_2960.method_60656("widget/button_highlighted"));

    private boolean toggled = false;

    private final int zIndex;

    private final Consumer<ToggleButton> onRender;

    protected ToggleButton(int x, int y, int zIndex, int width, int height, class_2561 message, class_4241 onPress, class_7841 createNarration, Consumer<ToggleButton> onRender) {
        super(x, y, width, height, message, onPress, createNarration);

        this.zIndex = zIndex;
        this.onRender = onRender;
    }

    public static ToggleButton ofSlot(int x, int y, int z, AccessoriesBasedSlot slot) {
        return ToggleButton.toggleBuilder(class_2561.method_43473(), btn -> {
                    AccessoriesNetworking.sendToServer(SyncCosmeticToggle.of(slot.entity.equals(class_310.method_1551().field_1724) ? null : slot.entity, slot.accessoriesContainer.slotType(), slot.method_34266()));
                }).onRender(btn -> {
                    var bl = slot.accessoriesContainer.shouldRender(slot.method_34266());

                    if (bl == btn.toggled()) return;

                    btn.toggled(bl);
                    btn.method_47400(accessoriesToggleTooltip(bl));
                }).tooltip(accessoriesToggleTooltip(slot.accessoriesContainer.shouldRender(slot.method_34266())))
                .zIndex(z)
                .bounds(x, y, 5, 5)
                .build()
                .toggled(slot.accessoriesContainer.shouldRender(slot.method_34266()));
    }

    private static class_7919 accessoriesToggleTooltip(boolean value) {
        var key = "display.toggle." + (!value ? "show" : "hide");

        return class_7919.method_47407(class_2561.method_43471(Accessories.translationKey(key)));
    }

    public ToggleButton toggled(boolean value){
        this.toggled = value;

        return this;
    }

    public boolean toggled(){
        return this.toggled;
    }

    @Override
    public void method_25306(class_11907 inputWithModifiers) {
        this.field_22767.onPress(this);
    }

    public static ToggleButton.Builder toggleBuilder(class_2561 message, class_4185.class_4241 onPress) {
        return new ToggleButton.Builder(message, onPress);
    }

    @Override
    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.onRender.accept(this);

        var minecraft = class_310.method_1551();
        guiGraphics.method_52707(
            class_10799.field_56883,
                SPRITES.method_52729(this.toggled(), this.method_25367()),
                this.method_46426(),
                this.method_46427(),
                this.method_25368(),
                this.method_25364(),
                class_9848.method_61317(this.field_22765)
        );
        int i = this.field_22763 ? 16777215 : 10526880;
        this.method_48589(guiGraphics, minecraft.field_1772, i | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
    }

    public static class Builder {
        private final class_2561 message;
        private final class_4185.class_4241 onPress;
        @Nullable
        private class_7919 tooltip;
        private int x;
        private int y;
        private int zIndex = 0;
        private int width = 150;
        private int height = 20;
        private class_4185.class_7841 createNarration = class_4185.field_40754;

        private Consumer<ToggleButton> onRender = toggleButton -> {};

        public Builder(class_2561 message, class_4185.class_4241 onPress) {
            this.message = message;
            this.onPress = onPress;
        }

        public ToggleButton.Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public ToggleButton.Builder zIndex(int zIndex){
            this.zIndex = zIndex;

            return this;
        }

        public ToggleButton.Builder onRender(Consumer<ToggleButton> consumer){
            this.onRender = consumer;

            return this;
        }

        public ToggleButton.Builder width(int width) {
            this.width = width;
            return this;
        }

        public ToggleButton.Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public ToggleButton.Builder bounds(int x, int y, int width, int height) {
            return this.pos(x, y).size(width, height);
        }

        public ToggleButton.Builder tooltip(@Nullable class_7919 tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public ToggleButton.Builder createNarration(class_4185.class_7841 createNarration) {
            this.createNarration = createNarration;
            return this;
        }

        public ToggleButton build() {
            ToggleButton button = new ToggleButton(this.x, this.y, this.zIndex, this.width, this.height, this.message, this.onPress, this.createNarration, this.onRender);

            button.method_47400(this.tooltip);
            return button;
        }
    }
}
