package io.wispforest.accessories.client.gui.components;

import F;
import I;
import io.wispforest.owo.ui.component.EntityComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.renderstate.EntityElementRenderState;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.lwjgl.glfw.GLFW;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10017;
import net.minecraft.class_11908;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_7833;
import net.minecraft.class_8030;
import net.minecraft.class_897;
import net.minecraft.class_9064;

public class InventoryEntityComponent<E extends class_1297> extends EntityComponent<E> {

    private float startingRotation = -45;

    private float lastBbWidth = 0.0f;
    private float lastBbHeight = 0.0f;

    private ScaleFitType type = ScaleFitType.NONE;

    private boolean sideBySideMode = false;
    private int additionalOffset = 0;

    public InventoryEntityComponent(Sizing horizontalSizing, Sizing verticalSizing, E entity) {
        super(Sizing.fixed(0), entity);

        this.horizontalSizing(horizontalSizing)
                .verticalSizing(verticalSizing);

        this.lastBbWidth = entity.method_17681();
        this.lastBbHeight = entity.method_17682();
    }

    public InventoryEntityComponent(Sizing horizontalSizing, Sizing verticalSizing, class_1299<E> type, @Nullable class_2487 nbt) {
        super(Sizing.fixed(0), type, nbt);

        this.horizontalSizing(horizontalSizing)
                .verticalSizing(verticalSizing);

        this.lastBbWidth = entity.method_17681();
        this.lastBbHeight = entity.method_17682();
    }

    public static <E extends class_1297> InventoryEntityComponent<E> of(Sizing horizontalSizing, Sizing verticalSizing, E entity) {
        return new InventoryEntityComponent<E>(horizontalSizing, verticalSizing, entity);
    }

    public boolean sideBySideMode() {
        return this.sideBySideMode;
    }

    public InventoryEntityComponent<E> sideBySideMode(boolean sideBySideMode) {
        this.sideBySideMode = sideBySideMode;

        return this;
    }

    public int additionalOffset() {
        return this.additionalOffset;
    }

    public InventoryEntityComponent<E> additionalOffset(int value) {
        this.additionalOffset = value;

        return this;
    }

    private float getEntityScale() {
        return (entity instanceof class_1309 living) ? living.method_55693() : 1.0f;
    }

    public float xOffset = 0.0f;
    public float yOffset = 0.0f;

    private TriConsumer<OwoUIDrawContext, Component, List<Runnable>> renderWrapping = (ctx, component, runnables) -> runnables.forEach(Runnable::run);

    public InventoryEntityComponent<E> renderWrapping(TriConsumer<OwoUIDrawContext, Component, List<Runnable>> renderWrapping) {
        this.renderWrapping = renderWrapping;

        return this;
    }

    public float getSingleInstanceWidth() {
        return (this.horizontalSizing().get().value / (sideBySideMode ? 2f : 1f)) - (sideBySideMode ? 25 : 40);
    }

    public InventoryEntityComponent<E> scaleToFit(boolean scaleToFit) {
        if(scaleToFit) {
            var componentHeight = (float) this.verticalSizing().get().value;
            var componentWidth = getSingleInstanceWidth();

            var entityHeight = entity.method_17682() * (Math.min(componentWidth, componentHeight) / Math.max(componentWidth, componentHeight));
            var entityWidth = entity.method_17681()* (Math.max(componentWidth, componentHeight) / Math.min(componentWidth, componentHeight));

            var length = Math.max(entityHeight, entityWidth);

            float baseScale = (.35f / length);

            this.scale(baseScale);

            type = ScaleFitType.BOTH;
        } else {
            this.scale(1);

            type = ScaleFitType.NONE;
        }

        return this;
    }

    public InventoryEntityComponent<E> startingRotation(float value) {
        this.startingRotation = value;

        return this;
    }

    public InventoryEntityComponent<E> scaleToFitVertically(boolean scaleToFit) {
        this.scale(scaleToFit ? (.5f / entity.method_17682()) : 1);

        type = scaleToFit ? ScaleFitType.VERTICAL : ScaleFitType.NONE;

        return this;
    }

    public InventoryEntityComponent<E> scaleToFitHorizontally(boolean scaleToFit) {
        this.scale(scaleToFit ? (.5f / entity.method_17681()) : 1);

        type = scaleToFit ? ScaleFitType.HORIZONTAL : ScaleFitType.NONE;

        return this;
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        if(!(entity instanceof class_1309 living)) {
            super.draw(context, mouseX, mouseY, partialTicks, delta);

            return;
        }

        if (this.lastBbWidth != entity.method_17681() || this.lastBbHeight != entity.method_17682()) {
            switch (type) {
                case VERTICAL -> this.scaleToFitVertically(true);
                case HORIZONTAL -> this.scaleToFitHorizontally(true);
                case BOTH -> this.scaleToFit(true);
                case NONE -> {}
            }

            this.lastBbWidth = entity.method_17681();
            this.lastBbHeight = entity.method_17682();
        }

        var renderQueue = new ArrayList<Runnable>();

        renderQueue.add(
                () -> {
                    context.push();
                    renderLiving(context, living, mouseX, mouseY, partialTicks, true);
                    context.pop();
                }
        );

        if (sideBySideMode) {
            renderQueue.add(
                    () -> {
                        context.push();
                        renderLiving(context, living, mouseX, mouseY, partialTicks, false);
                        context.pop();
                    }
            );
        }

        this.renderWrapping.accept(
                context,
                this,
                renderQueue
        );
    }

    private void renderLiving(OwoUIDrawContext context, class_1309 living, int mouseX, int mouseY, float partialTicks, boolean isLeftSide) {
        var matrix = new Matrix4f();

        transformMatrixStack(matrix, isLeftSide);

        this.transform.accept(matrix);

        float prevYBodyRot0 = living.field_6220;
        float prevYBodyRot = living.field_6283;
        float prevYRot = living.method_36454();
        float prevYRot0 = living.field_5982;
        float prevXRot = living.method_36455();
        float prevXRot0 = living.field_6004;
        float prevYHeadRot0 = living.field_6259;
        float prevYHeadRot = living.field_6241;

        rotateMatrixStack(matrix, living, mouseX, mouseY, isLeftSide);

        {
            living.field_6220 = 0;
            living.field_6283 = 0;
            living.method_36456(0);
            living.field_6241 = living.field_6283;
            living.field_6259 = living.field_6220;

            var renderer = (class_897) this.manager.method_3953(this.entity);

            var entityState = renderer.method_62425(this.entity, partialTicks);

            entityState.field_53325 = 0;
            entityState.field_53326 = 0;
            entityState.field_53327 = 0;

            if (showNametag) {
                // TODO: FIX LATER WITH OWO UPSTREAM
                entityState.field_53337 = entity.method_5476();
                entityState.field_53338 = entity.method_56072().method_55675(class_9064.field_47745, 0, entity.method_61415(partialTicks));
            } else {
                entityState.field_53337 = null;
                entityState.field_53338 = null;
            }

            context.field_59826.method_70922(new EntityElementRenderState(
                entityState,
                matrix,
                new class_8030(this.x, this.y, this.width, this.height),
                context.field_44659.method_70863()
            ));
        }

        living.field_6220 = prevYBodyRot0;
        living.field_6283 = prevYBodyRot;
        living.method_36456(prevYRot);
        living.field_5982 = prevYRot0;
        living.method_36457(prevXRot);
        living.field_6004 = prevXRot0;
        living.field_6259 = prevYHeadRot0;
        living.field_6241 = prevYHeadRot;
    }

    private void transformMatrixStack(Matrix4f matrix, boolean isLeftSide) {
        var trueWidth = this.width / (sideBySideMode ? 2f : 1f);

        var maxLength = Math.max(trueWidth, this.height);

        var baseScaleValue = 75 * this.scale;
        var xyScaleValue = baseScaleValue * maxLength / 64f;

        var yPos = this.height / 2f;

        matrix.translate(additionalOffset * (isLeftSide ? -2.3f : 2.3f), -yPos, 60);

        matrix.scale(xyScaleValue, -xyScaleValue, -baseScaleValue);

        matrix.translate(0, entity.method_17682() / -2f, 0);

        matrix.translate(this.xOffset * (isLeftSide ? 1 : -1), this.yOffset, 0);
    }

    private void rotateMatrixStack(Matrix4f matrix, class_1309 living, int mouseX, int mouseY, boolean isLeftSide) {
        var trueWidth = this.width / (sideBySideMode ? 2f : 1f);

        float xRotation = (float) Math.toDegrees(Math.atan((mouseY - this.y - this.height / 2f) / 40f));

        var rotationOffset = (!isLeftSide ? 180f : 0);

        if (this.lookAtCursor) {
            float yRotation = (float) Math.toDegrees(Math.atan((mouseX - this.x - (trueWidth / 2f)) / 40f));

            living.field_6259 = -yRotation;

            this.entity.field_5982 = -yRotation;
            this.entity.field_6004 = xRotation * .65f;

            this.entity.method_36456(this.entity.field_5982);
            this.entity.method_36457(this.entity.field_6004);

            // We make sure the xRotation never becomes 0, as the lighting otherwise becomes very unhappy
            if (xRotation == 0) xRotation = .1f;
            matrix.rotate(class_7833.field_40714.rotationDegrees(xRotation * .35f));
            matrix.rotate(class_7833.field_40716.rotationDegrees(yRotation * .555f + rotationOffset));
        } else {
            this.entity.field_6004 = xRotation * .35f;

            this.entity.method_36457(this.entity.field_6004);

            if (xRotation == 0) xRotation = .1f;
            matrix.rotate(class_7833.field_40714.rotationDegrees(xRotation * .15f));

            matrix.rotate(class_7833.field_40714.rotationDegrees(15));
            matrix.rotate(class_7833.field_40716.rotationDegrees(startingRotation + this.mouseRotation + rotationOffset));
        }
    }

    @Override
    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        this.scale += (float) (amount * this.scale * 0.1f);

        return true;
    }

    @Override
    public boolean onKeyPress(class_11908 input) {
        var keycode = input.comp_4795();

        if(keycode == GLFW.GLFW_KEY_LEFT) {
            this.xOffset -= 0.05f;
        } else if(keycode == GLFW.GLFW_KEY_RIGHT) {
            this.xOffset += 0.05f;
        }

        if(keycode == GLFW.GLFW_KEY_UP) {
            this.yOffset += 0.05f;
        } else if(keycode == GLFW.GLFW_KEY_DOWN) {
            this.yOffset -= 0.05f;
        }

        return super.onKeyPress(input);
    }

    public enum ScaleFitType {
        VERTICAL,
        HORIZONTAL,
        BOTH,
        NONE;
    }
}
