package io.wispforest.accessories.client.gui.components;

import com.mojang.blaze3d.textures.GpuTextureView;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11241;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.joml.Matrix3x2f;

public class PixelPerfectTextureComponent extends BaseComponent {

    private final class_2960 texture;

    public PixelPerfectTextureComponent(class_2960 texture, int textureWidth, int textureHeight, int scale) {
        this(texture, Sizing.fixed(textureWidth * scale), Sizing.fixed(textureHeight * scale));
    }

    public PixelPerfectTextureComponent(class_2960 texture, Sizing horizontalSizing, Sizing verticalSizing) {
        super();

        this.texture = texture;

        if(horizontalSizing.isContent()) throw new IllegalStateException("HorizontalSizing of PixelPerfectTextureComponent was found to be Content Sizing, which is not allowed!");
        if(verticalSizing.isContent()) throw new IllegalStateException("VerticalSizing of PixelPerfectTextureComponent was found to be Content Sizing, which is not allowed!");

        this.horizontalSizing(horizontalSizing);
        this.verticalSizing(verticalSizing);
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        drawPixelPerfectTextureQuad(context, texture, this.x(), this.y(), this.width(), this.height());
    }

    public static void drawPixelPerfectTextureQuad(OwoUIDrawContext context, class_2960 texture, int x1, int y1, int width, int height) {
        int x2 = x1 + width;
        int y2 = y1 + height;

        var gpuTextureView = class_310.method_1551().method_1531().method_4619(texture).method_71659();

        context.field_59826.method_70919(
            new class_11241(
                class_10799.field_56883,
                class_11231.method_70900(gpuTextureView),
                new Matrix3x2f(context.method_51448()),
                x1, y1,
                x2, y2,
                0, 1,
                0, 1,
                0xFFFFFFFF,
                context.field_44659.method_70863()
            )
        );
    }
}
