package io.wispforest.accessories.commands;

import I;
import Z;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.attributes.SlotAttribute;
import io.wispforest.accessories.api.client.rendering.RenderingFunction;
import io.wispforest.accessories.api.components.*;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.commands.api.CommandGenerators;
import io.wispforest.accessories.commands.api.CommandTreeGenerator;
import io.wispforest.accessories.commands.api.base.BranchedCommandGenerator;
import io.wispforest.accessories.commands.api.core.NamedArgumentGetter;
import io.wispforest.accessories.commands.api.core.RecordArgumentTypeInfo;
import io.wispforest.accessories.data.CustomRendererLoader;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.mixin.CommandSelectionAccessor;
import io.wispforest.accessories.mixin.ResourceArgumentAccessor;
import io.wispforest.endec.Endec;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2178;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2240;
import net.minecraft.class_2287;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import net.minecraft.commands.arguments.*;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

import java.util.*;

public class AccessoriesCommands implements CommandTreeGenerator.Branched {

    public static final AccessoriesCommands INSTANCE = new AccessoriesCommands();

    private AccessoriesCommands(){}

    public static final SimpleCommandExceptionType NON_LIVING_ENTITY_TARGET = new SimpleCommandExceptionType(class_2561.method_43471("accessories.argument.livingEntities.nonLiving"));

    public static final SimpleCommandExceptionType INVALID_SLOT_TYPE = new SimpleCommandExceptionType(new LiteralMessage("Invalid Slot Type"));

    public static final SimpleCommandExceptionType ERROR_CAPABILITY_MISSING = new SimpleCommandExceptionType(class_2561.method_43470("Unable to get the needed capability from the given target!"));

    public static final DynamicCommandExceptionType ERROR_CONTAINER_MISSING = new DynamicCommandExceptionType((obj) -> class_2561.method_43470("Unable to get the needed Container from the given target! [Container: " + obj + "]"));

    private static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
        CommandGenerators.create(
                "accessories",
                AccessoriesCommands.INSTANCE,
                registration -> {
                    registration.register(Accessories.of("slot_type"), SlotArgumentType.class, RecordArgumentTypeInfo.of(ctx -> SlotArgumentType.INSTANCE));
                    registration.register(Accessories.of("resource"), ResourceExtendedArgument.class, RecordArgumentTypeInfo.of(ResourceExtendedArgument::attributes));
                    registration.register(Accessories.of("slot_path"), AccessoriesMixedSlotArgument.class, RecordArgumentTypeInfo.of(Endec.STRING, "entity_argument_name", AccessoriesMixedSlotArgument::entityArgumentName, AccessoriesMixedSlotArgument::new));
                });
    }

    public static class_1309 getOrThrowLivingEntity(CommandContext<class_2168> ctx, String name) throws CommandSyntaxException {
        var entity = class_2186.method_9313(ctx, name);

        if(!(entity instanceof class_1309 livingEntity)) {
            throw NON_LIVING_ENTITY_TARGET.create();
        }

        return livingEntity;
    }

    public static AccessoriesCapability getCapability(class_1297 entity) throws CommandSyntaxException {
        if(!(entity instanceof class_1309 livingEntity)) throw AccessoriesCommands.NON_LIVING_ENTITY_TARGET.create();

        var capability = livingEntity.accessoriesCapability();

        if (capability == null) throw AccessoriesCommands.ERROR_CAPABILITY_MISSING.create();

        return capability;
    }

    public static AccessoriesContainer getContainer(class_1297 entity, String slot) throws CommandSyntaxException {
        var capability = getCapability(entity);

        var container = capability.getContainers().get(slot);

        if (container == null) throw AccessoriesCommands.ERROR_CONTAINER_MISSING.create(slot);

        return container;
    }

    @Override
    public <T> NamedArgumentGetter<class_2168, T> getArgumentGetter(ArgumentType<T> type) {
        var getter = getArgumentGetterErased(type);

        return getter != null ? (NamedArgumentGetter<class_2168, T>) getter : Branched.super.getArgumentGetter(type);
    }

    @Nullable
    public static <T> NamedArgumentGetter<class_2168, ?> getArgumentGetterErased(ArgumentType<T> type) {
        if (type instanceof class_2232) return class_2232::method_9443;
        if (type instanceof class_2178) return class_2178::method_67416;
        if (type instanceof BoolArgumentType) return BoolArgumentType::getBool;
        if (type instanceof SlotArgumentType) return SlotArgumentType::getSlot;
        if (type instanceof DoubleArgumentType) return DoubleArgumentType::getDouble;
        if (type instanceof IntegerArgumentType) return IntegerArgumentType::getInteger;
        if (type instanceof ResourceExtendedArgument<?>) return ResourceExtendedArgument::getResource;
        if (type instanceof class_7733<?> resourceArgument) {
            var key = (class_5321<class_2378<Object>>) ((ResourceArgumentAccessor<?>) resourceArgument).registryKey();
            return (ctx, name) -> class_7733.method_45602(ctx, name, key);
        }
        if (type instanceof AccessoriesMixedSlotArgument) return AccessoriesMixedSlotArgument::getSlot;
        if (type instanceof class_2240) return class_2240::method_9469;

        return null;
    }

    public void generateTrees(BranchedCommandGenerator root, class_7157 context, class_2170.class_5364 environment) {
        root.modifyRootNode(builder -> builder.requires(stack -> stack.method_9259(class_2170.field_31839)));

        if (((CommandSelectionAccessor) (Object) environment).accessories$includeIntegrated()) {
            root.branch("rendering", renderingBranch -> {
                renderingBranch.leaves(
                    "create-renderer-stack",
                    required("renderer_id", class_2232.method_9441()),
                    required("item_model_id", class_2232.method_9441()),
                    required("custom_name", class_2178.method_9281(context)),
                    defaulted("is_bundle", BoolArgumentType.bool(), false),
                    (ctx, rendererId, itemModelId, component, isBundle) -> {
                        AccessoriesCommands.createRenderStack(ctx, rendererId, itemModelId, component, isBundle);
                        return 0;
                    }
                ).leaves(
                    "listen-to-renderer",
                    defaulted("item_model_id", class_2232.method_9441(), null),
                    (ctx, id) -> {
                        CustomRendererLoader.constantFileResolving(ctx.getSource().method_9211(), id);

                        return 1;
                    }
                );
            });
        }

        root.leaves(
            "edit",
            defaulted("entity", class_2186.method_9309(), AccessoriesCommands::getOrThrowLivingEntity, null),
            (ctx, livingEntity) -> {
                Accessories.askPlayerForVariant(ctx.getSource().method_9207(), livingEntity);

                return 1;
            });

        var validLoggingBranches = List.of("slots", "groups", "entity_bindings");

        var logFailureType = new DynamicCommandExceptionType(branch -> class_2561.method_43469("accessories.commands.dump.failure", branch, validLoggingBranches.toString()));

        root.leaves(
            "dump",
            branches(validLoggingBranches),
            (ctx, branch) -> {
                switch (branch) {
                    case "slots" -> {
                        LOGGER.info("All given Slots registered:");

                        for (var slotType : SlotTypeLoader.INSTANCE.getEntries(ctx.getSource().method_9225()).values()) {
                            LOGGER.info(slotType.dumpData());
                        }
                    }
                    case "groups" -> {
                        LOGGER.info("All given Slot Groups registered:");

                        for (var group : SlotGroupLoader.getGroups(ctx.getSource().method_9225())) {
                            LOGGER.info(group.dumpData());
                        }
                    }
                    case "entity_bindings" ->{
                        LOGGER.info("All given Entity Bindings registered:");

                        EntitySlotLoader.INSTANCE.getEntitySlotData(false).forEach((type, slots) -> {
                            LOGGER.info("[EntityType: {}] <-> [Slots: {}]", type, slots.keySet());
                        });
                    }
                    default -> throw logFailureType.create(branch);
                }

                ctx.getSource().method_45068(class_2561.method_43469("accessories.commands.dump.success", branch));

                return 1;
            }
        );

        AccessoriesItemCommands.INSTANCE.generateTrees(root, context, environment);

        root.branch("slot", slotBranch -> {
            slotBranch
                .leaves(
                    "get",
                    required("entity", class_2186.method_9309(), class_2186::method_9313),
                    required("slot", SlotArgumentType.INSTANCE),
                    defaulted("scale", DoubleArgumentType.doubleArg(), 1.0),
                    (ctx, entity, slot, scale) -> {
                        var container = getContainer(entity, slot);

                        var size = container.getSize();

                        ctx.getSource().method_9226(
                                () -> class_2561.method_43469("accessories.commands.slot.value.get.success", class_2561.method_43471(Accessories.translationKey("slot." + slot.replace(":", "."))), entity.method_5477(), size),
                                false
                        );

                        return (int)(size * scale);
                    }
                )
                .branch("modifier", modiferBranch -> {
                    modiferBranch
                        .leaves(
                            "clear",
                            required("entity", class_2186.method_9309(), class_2186::method_9313),
                            defaulted("slot", SlotArgumentType.INSTANCE, ""),
                            (ctx, entity, s) -> {
                                if (s.isBlank()) {
                                    var capability = getCapability(entity);

                                    capability.clearSlotModifiers();

                                    ctx.getSource().method_9226(
                                        () -> class_2561.method_43469(
                                            "accessories.commands.slot.modifier.clear.all.success", entity.method_5477()
                                        ),
                                        false
                                    );
                                } else {
                                    var container = getContainer(entity, s);

                                    container.clearModifiers();

                                    ctx.getSource().method_9226(
                                        () -> class_2561.method_43469(
                                            "accessories.commands.slot.modifier.clear.container.success", s, entity.method_5477()
                                        ),
                                        false
                                    );
                                }

                                return 1;
                            }
                        )
                        .branch(
                            required("entity", class_2186.method_9309(), class_2186::method_9313),
                            required("slot", SlotArgumentType.INSTANCE),
                            required("id", class_2232.method_9441()),
                            branchBuilder -> {
                                branchBuilder.leaves(
                                    "add",
                                    required("amount", DoubleArgumentType.doubleArg()),
                                    branches(List.of("add_value", "add_multiplied_base", "add_multiplied_total"), operationTypeStr -> {
                                        return Arrays.stream(class_1322.class_1323.values())
                                            .filter(value -> value.method_15434().equals(operationTypeStr))
                                            .findFirst()
                                            .orElse(null);
                                    }),
                                    defaulted("is_persistent", BoolArgumentType.bool(), true),
                                    (ctx, entity, slot, id, amount, operation, isPersistent) -> {
                                        var container = getContainer(entity, slot);

                                        var modifier = new class_1322(id, amount, operation);

                                        if (isPersistent) {
                                            container.addPersistentModifier(modifier);
                                        } else {
                                            container.addTransientModifier(modifier);
                                        }

                                        ctx.getSource().method_45068(class_2561.method_43469("accessories.commands.slot.modifier.addition", id, slot, entity.method_5476()));

                                        return 1;
                                    }
                                ).leaves(
                                    "remove",
                                    (ctx, entity, slot, id) -> {
                                        var container = getContainer(entity, slot);

                                        var doseExist = container.hasModifier(id);

                                        if(doseExist) container.removeModifier(id);

                                        var messageType = (doseExist
                                            ? "accessories.commands.slot.modifier.removed.success"
                                            : "accessories.commands.slot.modifier.removed.failure");

                                        ctx.getSource().method_45068(class_2561.method_43469(messageType, id, slot, entity.method_5476()));

                                        return 1;
                                    }
                                ).leaves(
                                    "get",
                                    defaulted("scale", DoubleArgumentType.doubleArg(), 1.0),
                                    (ctx, entity, slot, id, scale) -> {
                                        var container = getContainer(entity, slot);
                                        var modifiers = container.getModifiers();
                                        var attribute = SlotAttribute.getAttributeHolder(container.slotType());

                                        if (!modifiers.containsKey(id)) {
                                            throw ERROR_NO_SUCH_MODIFIER.create(entity.method_5477(), getAttributeDescription(attribute), id);
                                        }

                                        double d = modifiers.get(id).comp_2449();
                                        ctx.getSource().method_9226(
                                            () -> class_2561.method_43469(
                                                "commands.attribute.modifier.value.get.success", class_2561.method_54154(id), getAttributeDescription(attribute), entity.method_5477(), d
                                            ),
                                            false
                                        );
                                        return (int)(d * scale);
                                    }
                                );
                        });
                });
        });

        root.branch("components", itemComponentBranch -> {
            itemComponentBranch.leaves(
                "effect/add",
                required("effect", class_7733.method_45603(context, class_7924.field_41208)),
                defaulted("applyDelay", IntegerArgumentType.integer(1, 1000000), null),
                defaulted("seconds", IntegerArgumentType.integer(1, 1000000), -1),
                defaulted("amplifier", IntegerArgumentType.integer(0, 255), 1),
                defaulted("hideParticles", BoolArgumentType.bool(), null),
                defaulted("hideIcon", BoolArgumentType.bool(), null),
                (ctx, effect, applyDelay, seconds, amplifier, hideParticles, hideIcon) -> {
                    if (seconds == -1) {
                        if (hideParticles == null) hideParticles = true;
                    }

                    if (hideIcon == null) hideIcon = false;

                    var effectInstance = new class_1293(effect, seconds, amplifier, false, !hideParticles, !hideIcon);

                    var player = ctx.getSource().method_9207();

                    player.method_6047().method_57368(
                            AccessoriesDataComponents.MOB_EFFECTS,
                            AccessoryMobEffectsComponent.EMPTY,
                            data -> applyDelay != null
                                    ? data.addEffect(effectInstance, applyDelay)
                                    : data.addEffect(effectInstance));

                    return 1;
                }
            );

            //--

            itemComponentBranch.leaves(
                "nest",
                required("item", class_2287.method_9776(context), (ctx, name) -> class_2287.method_9777(ctx, name).method_9781(1, false)),
                (ctx, innerStack) -> {
                    var player = ctx.getSource().method_9207();

                    player.method_6047().method_57368(
                            AccessoriesDataComponents.NESTED_ACCESSORIES,
                            AccessoryNestContainerContents.EMPTY,
                            data -> data.addStack(innerStack));

                    ctx.getSource().method_45068(class_2561.method_43471("accessories.commands.nest.addition"));

                    return 1;
                });

            //--

            itemComponentBranch.leaves(
                "slot",
                branches("add", "remove"),
                branches("valid", "invalid"),
                required("slot", SlotArgumentType.INSTANCE),
                (ctx, operation, condition, slot) -> adjustSlotValidationOnStack(condition, Objects.equals(operation, "add"), slot, ctx)
            );

            //--

            itemComponentBranch.branch("stack-sizing", branchBuilder -> {
                branchBuilder.leaves(
                    "useStackSize",
                    required("value", BoolArgumentType.bool()),
                    (ctx, bl) -> {
                        var player = ctx.getSource().method_9207();

                        player.method_6047().method_57368(AccessoriesDataComponents.STACK_SETTINGS,
                                AccessoryStackSettings.DEFAULT,
                                component -> component.useStackSize(bl));

                        return 1;
                        }
                ).leaves(
                    required("size", IntegerArgumentType.integer()),
                    (ctx, size) -> {
                        var player = ctx.getSource().method_9207();

                        player.method_6047().method_57368(AccessoriesDataComponents.STACK_SETTINGS,
                                AccessoryStackSettings.DEFAULT,
                                component -> component.sizeOverride(size));

                        return 1;
                    }
                );
            });

            //--

            itemComponentBranch.branch(
                "attribute",
                required("attribute", ResourceExtendedArgument.attributes(context)),
                required("id", class_2232.method_9441()),
                branchBuilder -> {
                    branchBuilder.leaves(
                            "add",
                            required("amount", DoubleArgumentType.doubleArg()),
                            branches(List.of("add_value", "add_multiplied_base", "add_multiplied_total"), operationTypeStr -> {
                                return Arrays.stream(class_1322.class_1323.values())
                                        .filter(value -> value.method_15434().equals(operationTypeStr))
                                        .findFirst()
                                        .orElse(null);
                            }),
                            required("slot", SlotArgumentType.INSTANCE),
                            required("isStackable", BoolArgumentType.bool()),
                            defaulted("usedInSlotValidation", BoolArgumentType.bool(), false),
                            AccessoriesCommands::addModifier
                    ).leaves(
                            "remove",
                            AccessoriesCommands::removeModifier
                    ).leaves(
                            "get",
                            defaulted("scale", DoubleArgumentType.doubleArg(), 1.0),
                            AccessoriesCommands::getAttributeModifier
                    );
                });
        });
    }

    private static int getAttributeModifier(CommandContext<class_2168> ctx, class_6880<class_1320> holder, class_2960 resourceLocation, double d) throws CommandSyntaxException {
        var commandSourceStack = ctx.getSource();
        var livingEntity = ctx.getSource().method_9207();

        var stack = livingEntity.method_6047();

        var component = stack.method_58695(AccessoriesDataComponents.ATTRIBUTES, AccessoryItemAttributeModifiers.EMPTY);

        var modifier = component.getModifier(holder, resourceLocation);

        if (modifier == null) {
            throw ERROR_NO_SUCH_MODIFIER.create(stack.method_7954(), getAttributeDescription(holder), resourceLocation);
        }

        double e = modifier.comp_2449();

        commandSourceStack.method_9226(
                () -> class_2561.method_43469(
                        "accessories.commands.attribute.modifier.value.get.success_itemstack", class_2561.method_54154(resourceLocation), getAttributeDescription(holder), stack.method_7954(), e
                ),
                false
        );

        return (int)(e * d);
    }

    private static final Dynamic3CommandExceptionType ERROR_MODIFIER_ALREADY_PRESENT = new Dynamic3CommandExceptionType(
            (var1, var2, var3) -> class_2561.method_54159("accessories.commands.attribute.failed.modifier_already_present_itemstack", var1, var2, var3)
    );

    private static int addModifier(CommandContext<class_2168> ctx, class_6880<class_1320> holder, class_2960 resourceLocation, double d, class_1322.class_1323 operation, String slotName, boolean isStackable, boolean usedInSlotValidation) throws CommandSyntaxException {
        var commandSourceStack = ctx.getSource();

        if (operation == null) {
            commandSourceStack.method_9213(class_2561.method_43470("Unable to locate AttributeModifier Operation type passed to the command!"));

            return -1;
        }

        var livingEntity = ctx.getSource().method_9207();
        var stack = livingEntity.method_6047();

        var component = stack.method_58695(AccessoriesDataComponents.ATTRIBUTES, AccessoryItemAttributeModifiers.EMPTY);

        if (component.hasModifier(holder, resourceLocation)) {
            throw ERROR_MODIFIER_ALREADY_PRESENT.create(resourceLocation, getAttributeDescription(holder), stack.method_7954());
        }

        stack.method_57379(AccessoriesDataComponents.ATTRIBUTES, component.withModifierAdded(holder, new class_1322(resourceLocation, d, operation), slotName, isStackable, usedInSlotValidation));

        commandSourceStack.method_9226(
                () -> class_2561.method_43469(
                        "accessories.commands.attribute.modifier.add.success_itemstack", class_2561.method_54154(resourceLocation), getAttributeDescription(holder), stack.method_7954()
                ),
                false
        );

        return 1;
    }

    private static final Dynamic3CommandExceptionType ERROR_NO_SUCH_MODIFIER = new Dynamic3CommandExceptionType(
            (var1, var2, var3) -> class_2561.method_54159("accessories.commands.attribute.failed.no_modifier_itemstack", var1, var2, var3)
    );

    private static int removeModifier(CommandContext<class_2168> ctx, class_6880<class_1320> holder, class_2960 location) throws CommandSyntaxException {
        var commandSourceStack = ctx.getSource();
        var livingEntity = ctx.getSource().method_9207();

        MutableBoolean removedModifier = new MutableBoolean(false);

        var stack = livingEntity.method_6047();

        stack.method_57368(AccessoriesDataComponents.ATTRIBUTES, AccessoryItemAttributeModifiers.EMPTY, component -> {
            var size = component.modifiers().size();

            component = component.withoutModifier(holder, location);

            if(size != component.modifiers().size()) removedModifier.setTrue();

            return component;
        });

        if(!removedModifier.getValue()) {
            throw ERROR_NO_SUCH_MODIFIER.create(location, stack.method_7954(), getAttributeDescription(holder));
        }

        commandSourceStack.method_9226(
                () -> class_2561.method_43469(
                        "accessories.commands.attribute.modifier.remove.success_itemstack", class_2561.method_54154(location), getAttributeDescription(holder), stack.method_7954()
                ),
                false
        );

        return 1;
    }

    private static class_2561 getAttributeDescription(class_6880<class_1320> attribute) {
        return class_2561.method_43471(attribute.comp_349().method_26830());
    }

    private static int adjustSlotValidationOnStack(String branch, boolean addSlot, String slotName, CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_1309 targetEntity = ctx.getSource().method_9207();

        targetEntity.method_6047().method_57368(AccessoriesDataComponents.SLOT_VALIDATION, AccessorySlotValidationComponent.EMPTY, component -> {
            return (Objects.equals(branch, "valid"))
                    ? (addSlot ? component.addValidSlot(slotName) : component.removeValidSlot(slotName))
                    : (addSlot ? component.addInvalidSlot(slotName) : component.removeInvalidSlot(slotName));
        });

        ctx.getSource().method_45068(class_2561.method_43469("accessories.commands.slot.validation." + (addSlot ? "added" : "removed") + "." + (branch), slotName));

        return 1;
    }

    private static int createRenderStack(CommandContext<class_2168> ctx, class_2960 rendererId, class_2960 modelId, class_2561 component, boolean isBundle) throws CommandSyntaxException {
        class_1792 item = class_1802.field_8600;

        try {
            if (ctx.getArgument("is_bundle", Boolean.class)) item = class_1802.field_27023;
        } catch (Throwable ignored) {}

        var itemStack = item.method_7854();

        itemStack.method_57379(class_9334.field_50239, component);

        itemStack.method_57379(
                AccessoriesDataComponents.CUSTOM_RENDERER,
                new AccessoryCustomRendererComponent(
                        List.of(new RenderingFunction.DeferredRenderer(rendererId, Map.of(), RenderingFunction.ArmTarget.BOTH)), null, false)
        );

        itemStack.method_57379(class_9334.field_54199, modelId);

        itemStack.method_57379(
                AccessoriesDataComponents.SLOT_VALIDATION,
                new AccessorySlotValidationComponent(Set.of("any"), Set.of())
        );

        ctx.getSource().method_9207()
                .method_7270(itemStack);

        return 1;
    }
}
