package io.wispforest.accessories.commands;


import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Either;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.commands.api.CommandTreeGenerator;
import io.wispforest.accessories.commands.api.base.Argument;
import io.wispforest.accessories.commands.api.base.BranchedCommandGenerator;
import io.wispforest.accessories.commands.api.core.NamedArgumentGetter;
import java.util.Optional;
import net.minecraft.class_117;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2240;
import net.minecraft.class_2262;
import net.minecraft.class_2287;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_47;
import net.minecraft.class_5630;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9433;

public class AccessoriesItemCommands implements CommandTreeGenerator.Branched {

    public static final AccessoriesItemCommands INSTANCE = new AccessoriesItemCommands();

    private AccessoriesItemCommands() {}

	private static final Dynamic3CommandExceptionType ERROR_TARGET_NOT_A_CONTAINER = new Dynamic3CommandExceptionType(
		(object, object2, object3) -> class_2561.method_54159("commands.item.target.not_a_container", object, object2, object3)
	);

	private static final Dynamic3CommandExceptionType ERROR_SOURCE_NOT_A_CONTAINER = new Dynamic3CommandExceptionType(
		(object, object2, object3) -> class_2561.method_54159("commands.item.source.not_a_container", object, object2, object3)
	);

	private static final DynamicCommandExceptionType ERROR_TARGET_INAPPLICABLE_SLOT = new DynamicCommandExceptionType(
		object -> class_2561.method_54159("commands.item.target.no_such_slot", object)
	);

	private static final DynamicCommandExceptionType ERROR_SOURCE_INAPPLICABLE_SLOT = new DynamicCommandExceptionType(
		object -> class_2561.method_54159("commands.item.source.no_such_slot", object)
	);

	private static final SuggestionProvider<class_2168> SUGGEST_MODIFIER = (commandContext, suggestionsBuilder) -> {
		return class_2172.method_71777(commandContext, suggestionsBuilder, class_7924.field_50080, class_2172.class_7078.field_37263);
	};

    @Override
    public <T> NamedArgumentGetter<class_2168, T> getArgumentGetter(ArgumentType<T> type) {
        var getter = AccessoriesCommands.getArgumentGetterErased(type);

        return getter != null ? (NamedArgumentGetter<class_2168, T>) getter : Branched.super.getArgumentGetter(type);
    }

    @Override
    public void generateTrees(BranchedCommandGenerator generator, class_7157 context, class_2170.class_5364 environment) {
		var slotArg = required("slot", class_2240.method_9473());

		var blockArg = required("pos", class_2262.method_9698(), class_2262::method_9696);

		var modifierArg = defaulted("modifier", class_9433.method_58486(context), class_9433::method_58485, null, SUGGEST_MODIFIER);

		var sourceSlotArg = required("sourceSlot", class_2240.method_9473());

		generator
				.branch("item")
				.branch("replace", replaceBranch -> {
					replaceBranch
							.branch(
									"block",
									blockArg,
									slotArg,
									blockBranch -> {
										blockBranch.branch("from", fromBranch -> {
											fromBranch.leaves(
													"entity",
													required("source_entity", class_2186.method_9309(), class_2186::method_9313),
													required("source_path", AccessoriesMixedSlotArgument.slot("source_entity")),
													modifierArg,
													(ctx, targetPos, targetSlot, sourceEntity, sourceSlot, modifier) -> {
														return (modifier == null)
																? entityToBlock(ctx.getSource(), sourceEntity, sourceSlot, targetPos, targetSlot)
																: entityToBlock(ctx.getSource(), sourceEntity, sourceSlot, targetPos, targetSlot, modifier);
													}
											);
										});
									}
							)
							.branch(
									"entity",
									required("entity", class_2186.method_9309(), class_2186::method_9313),
									required("path", AccessoriesMixedSlotArgument.slot("entity")),
									entityBranch -> {
										entityBranch
												.leaves(
														"with",
														required("item", class_2287.method_9776(context), (ctx, name) -> class_2287.method_9777(ctx, name).method_9781(1, false)),
														defaulted("count", IntegerArgumentType.integer(1, 99), 1),
														(ctx, entity, slot, stack, count) -> {
															stack.method_7939(count);

															return setEntityItem(ctx.getSource(), entity, slot, stack);
														}
												)
												.branch("from", fromBranch -> {
													fromBranch.leaves(
															"block",
															required("source", class_2262.method_9698(), class_2262::method_9696),
															sourceSlotArg,
															modifierArg,
															(ctx, targetPos, targetSlot, sourcePos, sourceSlot, modifier) -> {
																return (modifier == null)
																		? blockToEntity(ctx.getSource(), sourcePos, sourceSlot, targetPos, targetSlot)
																		: blockToEntity(ctx.getSource(), sourcePos, sourceSlot, targetPos, targetSlot, modifier);
															}
													).leaves(
															"entity",
															required("source_entity", class_2186.method_9309(), class_2186::method_9313),
															required("source_path", AccessoriesMixedSlotArgument.slot("source_entity")),
															modifierArg,
															(ctx, targetEntity, targetPath, sourceEntity, sourcePath, modifier) -> {
																return (modifier == null)
																		? entityToEntity(ctx.getSource(), sourceEntity, sourcePath, targetEntity, targetPath)
																		: entityToEntity(ctx.getSource(), sourceEntity, sourcePath, targetEntity, targetPath, modifier);
															}
													);
												});
							}
					);
				})
				.branch("modify", modifyBranch -> {
					modifyBranch.leaves(
							"entity",
							required("entity", class_2186.method_9309(), class_2186::method_9313),
							required("path", AccessoriesMixedSlotArgument.slot("entity")),
							modifierArg,
							(ctx, entity, path, modifier) -> modifyEntityItem(ctx.getSource(), entity, path, modifier)
					);
				});
	}

	private static int blockToEntity(class_2168 source, class_2338 pos, int sourceSlot, class_1297 target, Either<SlotPath, Integer> slot) throws CommandSyntaxException {
		return setEntityItem(source, target, slot, getBlockItem(source, pos, sourceSlot));
	}

	private static int blockToEntity(class_2168 source, class_2338 pos, int sourceSlot, class_1297 target, Either<SlotPath, Integer> slot, class_6880<class_117> modifier) throws CommandSyntaxException {
		return setEntityItem(source, target, slot, applyModifier(source, modifier, getBlockItem(source, pos, sourceSlot)));
	}

	private static int entityToBlock(class_2168 source, class_1297 sourceEntity, Either<SlotPath, Integer> sourceSlot, class_2338 pos, int slot) throws CommandSyntaxException {
		return setBlockItem(source, pos, slot, getEntityItem(sourceEntity, sourceSlot));
	}

	private static int entityToBlock(class_2168 source, class_1297 sourceEntity, Either<SlotPath, Integer> sourceSlot, class_2338 pos, int slot, class_6880<class_117> modifier) throws CommandSyntaxException {
		return setBlockItem(source, pos, slot, applyModifier(source, modifier, getEntityItem(sourceEntity, sourceSlot)));
	}

	private static int entityToEntity(class_2168 source, class_1297 sourceEntity, Either<SlotPath, Integer> sourceSlot, class_1297 targetEntity, Either<SlotPath, Integer> targetSlot) throws CommandSyntaxException {
		return setEntityItem(source, targetEntity, targetSlot, getEntityItem(sourceEntity, sourceSlot));
	}

	private static int entityToEntity(class_2168 source, class_1297 sourceEntity, Either<SlotPath, Integer> sourceSlot, class_1297 targetEntity, Either<SlotPath, Integer> targetSlot, class_6880<class_117> modifier) throws CommandSyntaxException {
		return setEntityItem(source, targetEntity, targetSlot, applyModifier(source, modifier, getEntityItem(sourceEntity, sourceSlot)));
	}

	private static class_1799 applyModifier(class_2168 source, class_6880<class_117> modifier, class_1799 originalStack) {
		var lootParams = new class_8567.class_8568(source.method_9225())
			.method_51874(class_181.field_24424, source.method_9222())
			.method_51877(class_181.field_1226, source.method_9228())
			.method_51875(class_173.field_20761);

		var lootContext = new class_47.class_48(lootParams).method_309(Optional.empty());

		lootContext.method_298(class_47.method_51186(modifier.comp_349()));

		var modifiedStack = modifier.comp_349().apply(originalStack, lootContext);

		modifiedStack.method_58408(modifiedStack.method_7914());

		return modifiedStack;
	}

	public static final Dynamic2CommandExceptionType ERROR_INVALID_SLOT_INDEX = new Dynamic2CommandExceptionType((ob1, ob2) -> class_2561.method_43470("The given path for [" + ob1 + "] container is invalid: [Path: " + ob2 +  "]"));

	//--

	private static class_1799 getEntityItem(class_1297 entity, Either<SlotPath, Integer> slot) throws CommandSyntaxException {
		if (slot.right().isPresent()) {
			var index = slot.right().get();

			class_5630 slotAccess = entity.method_32318(index);

			if (slotAccess == class_5630.field_27860) throw ERROR_SOURCE_INAPPLICABLE_SLOT.create(slot);

			return slotAccess.method_32327().method_7972();
		} else {
			if(!(entity instanceof class_1309 livingEntity)) throw AccessoriesCommands.NON_LIVING_ENTITY_TARGET.create();
			if (livingEntity.accessoriesCapability() == null) throw AccessoriesCommands.ERROR_CAPABILITY_MISSING.create();

			var slotPath = slot.left().get();
			var reference = SlotReference.of(livingEntity, slotPath);

			var container = reference.slotContainer();

			if (container == null) throw AccessoriesCommands.ERROR_CONTAINER_MISSING.create(reference.slotName());

			var stack = reference.getStack();

			if (stack == null) throw ERROR_INVALID_SLOT_INDEX.create(slotPath.slotName(), slotPath);

			return stack.method_7972();
		}
	}

	private static int setEntityItem(class_2168 source, class_1297 entity, Either<SlotPath, Integer> slot, class_1799 stack) throws CommandSyntaxException {
		if (slot.right().isPresent()) {
			var index = slot.right().get();

			class_5630 slotAccess = entity.method_32318(index);

			if (slotAccess == class_5630.field_27860) throw ERROR_SOURCE_INAPPLICABLE_SLOT.create(slot);

			slotAccess.method_32332(stack);
		} else {
			if(!(entity instanceof class_1309 livingEntity)) throw AccessoriesCommands.NON_LIVING_ENTITY_TARGET.create();
			var slotPath = slot.left().get();
			var reference = SlotReference.of(livingEntity, slotPath);

			var container = reference.slotContainer();

			if (container == null) throw AccessoriesCommands.ERROR_CONTAINER_MISSING.create(reference.slotName());

			if (reference.setStack(stack)) throw ERROR_INVALID_SLOT_INDEX.create(slotPath.slotName(), slotPath);
		}

		return 1;
	}

	//--

	private static class_1799 getBlockItem(class_2168 source, class_2338 pos, int slot) throws CommandSyntaxException {
		var container = getContainer(source, pos, ERROR_SOURCE_NOT_A_CONTAINER);

		if (slot >= 0 && slot < container.method_5439()) return container.method_5438(slot).method_7972();

		throw ERROR_SOURCE_INAPPLICABLE_SLOT.create(slot);
	}

	private static int setBlockItem(class_2168 source, class_2338 pos, int slot, class_1799 item) throws CommandSyntaxException {
		var container = getContainer(source, pos, ERROR_TARGET_NOT_A_CONTAINER);

		if (slot >= 0 && slot < container.method_5439()) {
			container.method_5447(slot, item);
			source.method_9226(() -> class_2561.method_43469("commands.item.block.set.success", pos.method_10263(), pos.method_10264(), pos.method_10260(), item.method_7954()), true);
			return 1;
		}

		throw ERROR_TARGET_INAPPLICABLE_SLOT.create(slot);
	}

	private static class_1263 getContainer(class_2168 source, class_2338 pos, Dynamic3CommandExceptionType exception) throws CommandSyntaxException {
		if (source.method_9225().method_8321(pos) instanceof class_1263 container) return container;

		throw exception.create(pos.method_10263(), pos.method_10264(), pos.method_10260());
	}

	//--

	private static int modifyEntityItem(class_2168 source, class_1297 target, Either<SlotPath, Integer> slot, class_6880<class_117> modifer) throws CommandSyntaxException {
		class_1799 modifiedStack = applyModifier(source, modifer, getEntityItem(target, slot).method_7972());

		setEntityItem(source, target, slot, modifiedStack);

		source.method_9226(
				() -> class_2561.method_43469("commands.item.entity.set.success.single", target.method_5476(), modifiedStack.method_7954()),
				true
		);

		return 1;
	}
}
