package io.wispforest.accessories.commands.api;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.wispforest.accessories.commands.api.base.BaseCommandGenerator;
import io.wispforest.accessories.commands.api.base.BranchedCommandGenerator;
import io.wispforest.accessories.commands.api.base.CommandGenerator;
import io.wispforest.accessories.commands.api.core.Key;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;

public class CommandGenerators {

    private static final List<Holder<?>> ALL_COMMAND_GENERATORS = new ArrayList<>();

    public static void create(CommandTreeGenerator<class_2168, class_7157, CommandGenerator> generateTrees) {
        create(generateTrees, argumentRegistration -> {});
    }

    public static void create(CommandTreeGenerator<class_2168, class_7157, CommandGenerator> generateTrees, OnArgumentRegistration registration) {
        ALL_COMMAND_GENERATORS.add(new Holder<>(new CommandGenerator(), generateTrees, registration));
    }

    public static void create(String key, CommandTreeGenerator<class_2168, class_7157, BranchedCommandGenerator> generateTrees) {
        create(key, generateTrees, argumentRegistration -> {});
    }

    public static void create(String key, CommandTreeGenerator<class_2168, class_7157, BranchedCommandGenerator> generateTrees, OnArgumentRegistration registrationConsumer) {
        ALL_COMMAND_GENERATORS.add(new Holder<>(new BranchedCommandGenerator(new Key(key)), generateTrees, registrationConsumer));
    }

    //--

    public static void registerAllGenerators(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 environment) {
        for (var holder : ALL_COMMAND_GENERATORS) {
            holder.registerCommands(dispatcher, context, environment);
        }
    }

    public static void registerAllArgumentTypes(ArgumentRegistrationCallback registration) {
        for (var holder : ALL_COMMAND_GENERATORS) {
            holder.registration().registerArgumentTypes(registration);
        }
    }

    private record Holder<G extends BaseCommandGenerator<class_2168, G>>(G generator, CommandTreeGenerator<class_2168, class_7157, G> treeGenerator, OnArgumentRegistration registration){
        public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 environment) {
            treeGenerator.generateTrees(generator, context, environment);

            generator.addToCommandsAndClear((string, builtRootNode) -> {
                if (!(builtRootNode instanceof LiteralArgumentBuilder<?> literalArgumentBuilder)) {
                    throw new IllegalArgumentException("A root command node was found not to be a valid root literal!!!!");
                }

                dispatcher.register((LiteralArgumentBuilder<class_2168>) literalArgumentBuilder);
            });
        }
    }
}
