package io.wispforest.accessories.commands.api.base;

import io.wispforest.accessories.commands.api.core.CommandAddition;
import io.wispforest.accessories.commands.api.core.Key;
import java.util.List;
import net.minecraft.class_2168;

public final class BranchedCommandGenerator extends BaseCommandGenerator<class_2168, BranchedCommandGenerator> implements CommandTreeBuilder.BranchedCommandTreeBuilder<class_2168, BranchedCommandGenerator> {

    private final Key branchKey;

    public BranchedCommandGenerator(Key branchKey) {
        if (branchKey.isEmpty()) {
            throw new IllegalStateException("Branched Command Generators are not designed to have an empty key, use CommandGenerators.create without a key or give a valid key!");
        }

        this.branchKey = branchKey;
    }

    public void modifyRootNode(CommandAddition<class_2168> addition) {
        modifyNode(this.branchKey(), addition);
    }

    public BranchedCommandNodeHandler<class_2168> modifyUnderRoot() {
        return this.modifyUnder(this.branchKey());
    }

    @Override
    public BranchedCommandGenerator leaves(List<Argument<?>> startingArgs, List<Argument<?>> commandArgs, CommandAddition<class_2168> commandAddition) {
        super.leaves(addStartingToArgs(startingArgs), commandArgs, commandAddition);

        return getThis();
    }

    @Override
    public BranchedCommandGenerator getThis() {
        return this;
    }

    @Override
    public Key branchKey() {
        return this.branchKey;
    }
}
