package io.wispforest.accessories.commands.api.core;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.bytebuf.ByteBufDeserializer;
import io.wispforest.endec.format.bytebuf.ByteBufSerializer;
import io.wispforest.endec.format.gson.GsonSerializer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_7157;

public record RecordArgumentTypeInfo<A extends ArgumentType<?>, T>(StructEndec<T> endec, Function<A, T> toTemplate, BiFunction<class_7157, T, A> fromTemplate) implements class_2314<A, RecordArgumentTypeInfo.RecordInfoTemplate<A, T>> {

    public static <A extends ArgumentType<?>, T> RecordArgumentTypeInfo<A, T> of(StructEndec<T> endec, Function<A, T> toTemplate, Function<T, A> fromTemplate){
        return of(endec, toTemplate, (ctx, t) -> fromTemplate.apply(t));
    }

    public static <A extends ArgumentType<?>, T> RecordArgumentTypeInfo<A, T> of(StructEndec<T> endec, Function<A, T> toTemplate, BiFunction<class_7157, T, A> fromTemplate){
        return new RecordArgumentTypeInfo<>(endec, toTemplate, fromTemplate);
    }

    public static <A extends ArgumentType<?>, T> RecordArgumentTypeInfo<A, T> of(Endec<T> endec, String fieldName, Function<A, T> toTemplate, Function<T, A> fromTemplate){
        return of(endec, fieldName, toTemplate, (ctx, t) -> fromTemplate.apply(t));
    }

    public static <A extends ArgumentType<?>, T> RecordArgumentTypeInfo<A, T> of(Endec<T> endec, String fieldName, Function<A, T> toTemplate, BiFunction<class_7157, T, A> fromTemplate){
        return new RecordArgumentTypeInfo<>(endec.structOf(fieldName), toTemplate, fromTemplate);
    }

    public static <A extends ArgumentType<?>> RecordArgumentTypeInfo<A, Void> of(Function<class_7157, A> argTypeConstructor) {
        return new RecordArgumentTypeInfo<>(Endec.unit(() -> null), a -> null, (commandBuildContext, unused) -> argTypeConstructor.apply(commandBuildContext));
    }

    @Override
    public void serializeToNetwork(RecordInfoTemplate<A, T> template, class_2540 buffer) {
        endec.encodeFully(() -> ByteBufSerializer.of(buffer), template.data());
    }

    @Override
    public RecordInfoTemplate<A, T> deserializeFromNetwork(class_2540 buffer) {
        return new RecordInfoTemplate<>(this, endec.decodeFully(ByteBufDeserializer::of, buffer), fromTemplate);
    }

    @Override
    public void serializeToJson(RecordInfoTemplate<A, T> template, JsonObject json) {
        json.asMap().putAll(((JsonObject) endec.encodeFully(GsonSerializer::of, template.data())).asMap());
    }

    @Override
    public RecordInfoTemplate<A, T> unpack(A argument) {
        return new RecordInfoTemplate<>(this, toTemplate.apply(argument), fromTemplate);
    }

    public record RecordInfoTemplate<A extends ArgumentType<?>, T>(class_2314<A, ?> type, T data, BiFunction<class_7157, T, A> fromTemplate) implements Template<A> {
        @Override public A instantiate(class_7157 ctx) { return fromTemplate.apply(ctx, data()); }
    }
}
