package io.wispforest.accessories.compat.jei;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import net.minecraft.class_2960;
import net.minecraft.class_768;
import java.util.List;

@JeiPlugin
public class AccessoriesClientJEIPlugin implements IModPlugin {
    @Override
    public class_2960 getPluginUid() {
        return Accessories.of("main");
    }

    @Override
    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(AccessoriesScreen.class, new IGuiContainerHandler<AccessoriesScreen>() {
            @Override
            public List<class_768> getGuiExtraAreas(AccessoriesScreen screen) {
                return screen.getComponentRectangles().stream()
                        .map(rectangle -> new class_768(rectangle.x(), rectangle.y(), rectangle.width(), rectangle.height()))
                        .toList();
            }
        });
    }
}
