package io.wispforest.accessories.criteria;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.data.SlotGroupLoader;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;

public class AccessoryChangedCriterion extends class_4558<AccessoryChangedCriterion.Conditions> {

    public void trigger(class_3222 player, class_1799 accessory, SlotPath path, Boolean cosmetic) {
        this.method_22510(player, conditions -> {
            return conditions.itemPredicates().map(predicates -> predicates.stream().allMatch(predicate -> predicate.method_8970(accessory))).orElse(true)
                    && conditions.groups().flatMap(groups -> SlotGroupLoader.INSTANCE.findGroup(false, path.slotName()).map(group -> groups.stream().noneMatch(s -> s.equals(group.name())))).orElse(true)
                    && conditions.slots().map(slots -> slots.stream().noneMatch(path.slotName()::equals)).orElse(true)
                    && conditions.indices().map(indices -> indices.stream().noneMatch(index -> index == path.index())).orElse(true)
                    && conditions.cosmetic().map(isCosmetic -> isCosmetic && cosmetic).orElse(true);
        });
    }

    @Override
    public @NotNull Codec<Conditions> method_54937() {
        return Conditions.CODEC;
    }

    public record Conditions(
            Optional<class_5258> player,
            Optional<List<class_2073>> itemPredicates,
            Optional<List<String>> groups,
            Optional<List<String>> slots,
            Optional<List<Integer>> indices,
            Optional<Boolean> cosmetic
    ) implements SimpleInstance {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group(
                class_2048.field_47250.optionalFieldOf("player").forGetter(Conditions::player),
                class_2073.field_45754.listOf().optionalFieldOf("items").forGetter(Conditions::itemPredicates),
                Codec.STRING.listOf().optionalFieldOf("groups").forGetter(Conditions::groups),
                Codec.STRING.listOf().optionalFieldOf("slots").forGetter(Conditions::slots),
                Codec.INT.listOf().optionalFieldOf("indices").forGetter(Conditions::indices),
                Codec.BOOL.optionalFieldOf("cosmetic").forGetter(Conditions::cosmetic)
                ).apply(instance, Conditions::new));
    }
}