package io.wispforest.accessories.data.api;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.mixin.SimpleJsonResourceReloadListenerAccessor;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationContext;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.RegistriesAttribute;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6903;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_7654;


// TODO: 1.21.4 ADJUSTMENTS SHOULD BE MADE TO USE LESS DIRECT CODE ANYWAYS
public abstract class EndecDataLoader<T> extends class_4309<T> {

    protected final String type;

    protected final class_2960 id;
    protected final Endec<T> endec;

    protected final Set<class_2960> dependencies;

    protected final SerializationContext context;

    protected final boolean requiresRegistries;

    private final Function<class_3302.class_11558, class_7225.@Nullable class_7874> registriesAccess;

    protected EndecDataLoader(class_2960 id, String type, Endec<T> endec, class_3264 packType) {
        this(id, type, endec, packType, false);
    }

    protected EndecDataLoader(class_2960 id, String type, Endec<T> endec, class_3264 packType, Set<class_2960> value) {
        this(id, type, endec, packType, SerializationContext.empty(),false, value);
    }

    protected EndecDataLoader(class_2960 id, String type, Endec<T> endec, class_3264 packType, boolean requiresRegistries) {
        this(id, type, endec, packType, SerializationContext.empty(), requiresRegistries);
    }

    protected EndecDataLoader(class_2960 id, String type, Endec<T> endec, class_3264 packType, SerializationContext context, boolean requiresRegistries) {
        this(id, type, endec, packType, context, requiresRegistries, Set.of());
    }

    protected EndecDataLoader(class_2960 id, String type, Endec<T> endec, class_3264 packType, SerializationContext context, boolean requiresRegistries, Set<class_2960> value) {
        super(new DelegatingCodec<>(endec.toString(), endec), class_7654.method_45114(type));

        this.id = id;
        this.type = type;
        this.endec = endec;
        this.context = context;
        this.requiresRegistries = requiresRegistries;
        this.dependencies = value;

        this.registriesAccess = AccessoriesInternals.registerLoader(packType, this);

        if (packType.equals(class_3264.field_14190) && this instanceof SyncedDataHelper<?> syncedDataLoader) {
            SyncedDataHelperManager.registerLoader(syncedDataLoader);
        }
    }

    public class_2960 getId() {
        return this.id;
    }

    public Set<class_2960> getDependencyIds() {
        return this.dependencies;
    }

    @Override
    public void prepareSharedState(class_11558 sharedState) {
        super.prepareSharedState(sharedState);

        var ctx = this.context;

        if (this.requiresRegistries) {
            var registries = registriesAccess.apply(sharedState);

            Objects.requireNonNull(registries, "Can not add the registries to endec context for the ManagedEndecDataLoader: " + this.getId());

            ctx = ctx.withAttributes(RegistriesAttribute.fromInfoGetter(new class_6903.class_9683(registries)));
        }

        getCodec().setCodec(ctx);
    }

    @ApiStatus.Internal
    private DelegatingCodec<T> getCodec() {
        return ((DelegatingCodec<T>) ((SimpleJsonResourceReloadListenerAccessor<T>) this).getCodec());
    }

    @Override
    protected Map<class_2960, T> method_20731(class_3300 resourceManager, class_3695 profiler) {
        var entries = super.method_20731(resourceManager, profiler);

        getCodec().resetCodec();

        return entries;
    }

    private static class DelegatingCodec<T> implements Codec<T> {

        private final String name;
        private final Endec<T> endec;

        @Nullable
        private Codec<T> codec = null;

        private DelegatingCodec(String name, Endec<T> endec) {
            this.name = name;
            this.endec = endec;
        }

        void setCodec(SerializationContext ctx) {
            this.codec = CodecUtils.toCodec(this.endec, ctx);
        }

        void resetCodec() {
            this.codec = null;
        }

        Codec<T> getOrThrow() {
            if (codec == null) throw new IllegalStateException("Unable to get codec as such has yet to be setup with the proper context!");

            return codec;
        }

        @Override
        public <S> DataResult<Pair<T, S>> decode(final DynamicOps<S> ops, final S input) {
            return this.getOrThrow().decode(ops, input);
        }

        @Override
        public <S> DataResult<S> encode(final T input, final DynamicOps<S> ops, final S prefix) {
            return this.getOrThrow().encode(input, ops, prefix);
        }

        @Override
        public String toString() {
            return "RecursiveCodec[" + name + ']';
        }
    }
}
