package io.wispforest.accessories.data.api;

import io.wispforest.endec.Endec;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public interface SyncedDataHelper<D> {

    static <D> SyncedDataHelper<D> of(class_2960 id, Endec<D> endec, Consumer<D> onReceived, Supplier<D> getDataSupplier, class_2960 ...dependencies){
        return new SyncedDataHelper<D>() {
            @Override public class_2960 getId() { return id; }
            @Override public Set<class_2960> getDependencyIds() { return Set.of(dependencies); }

            @Override public Endec<D> syncDataEndec() { return endec; }

            @Override public D getServerData() { return getDataSupplier.get(); }
            @Override public void onReceivedData(D data) { onReceived.accept(data); }
        };
    }

    Endec<D> syncDataEndec();

    @ApiStatus.OverrideOnly
    void onReceivedData(D data);

    @ApiStatus.Internal
    @Nullable
    default Exception onReceivedDataUnsafe(Object data) {
        try {
            onReceivedData((D) data);
        } catch (Exception e) {
            return e;
        }

        return null;
    }

    class_2960 getId();

    Set<class_2960> getDependencyIds();

    @ApiStatus.OverrideOnly
    D getServerData();
}
