package io.wispforest.accessories.fabric;

import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import io.wispforest.accessories.data.api.EndecDataLoader;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.menu.AccessoriesMenuData;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import io.wispforest.endec.Endec;
import io.wispforest.owo.serialization.CodecUtils;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.impl.resource.conditions.ResourceConditionsImpl;
import net.minecraft.class_10712;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_3917;
import net.minecraft.class_4080;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7923;
import net.minecraft.class_9285;
import net.minecraft.class_9285.class_11193.class_11194;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class AccessoriesInternalsImpl {

    public static AccessoriesHolderImpl getHolder(class_1309 livingEntity){
        return livingEntity.getAttachedOrCreate(AccessoriesFabric.HOLDER_ATTACHMENT_TYPE);
    }

    public static void modifyHolder(class_1309 livingEntity, UnaryOperator<AccessoriesHolderImpl> modifier){
        var holder = (AccessoriesHolderImpl) getHolder(livingEntity);

        holder = modifier.apply(holder);

        livingEntity.setAttached(AccessoriesFabric.HOLDER_ATTACHMENT_TYPE, holder);
    }

    public static AccessoriesPlayerOptionsHolder getPlayerOptions(class_1657 player) {
        return player.getAttachedOrCreate(AccessoriesFabric.PLAYER_OPTIONS_ATTACHMENT_TYPE);
    }

    public static void modifyPlayerOptions(class_1657 player, UnaryOperator<AccessoriesPlayerOptionsHolder> modifier) {
        var options = getPlayerOptions(player);

        options = modifier.apply(options);

        player.setAttached(AccessoriesFabric.PLAYER_OPTIONS_ATTACHMENT_TYPE, options);
    }

    //--

    public static void giveItemToPlayer(class_3222 player, class_1799 stack) {
        if(stack.method_7960()) return;

        try(var transaction = Transaction.openOuter()) {
            PlayerInventoryStorage.of(player).offerOrDrop(ItemVariant.of(stack), stack.method_7947(), transaction);
            transaction.commit();
        }
    }

    public static boolean isValidOnConditions(JsonObject object, String dataType, class_2960 key, class_4080 listener, @Nullable class_6903.class_7863 registryInfo) {
        return ResourceConditionsImpl.applyResourceConditions(object, dataType, key, registryInfo);
    }

    public static <T extends class_1703, D> class_3917<T> registerMenuType(class_2960 location, Endec<D> endec, TriFunction<Integer, class_1661, D, T> func){
        return class_2378.method_10230(class_7923.field_41187, location, new ExtendedScreenHandlerType<>(func::apply, CodecUtils.toPacketCodec(endec)));
    }

    public static void openAccessoriesMenu(class_1657 player, AccessoriesMenuVariant variant, @Nullable class_1309 targetEntity, @Nullable class_1799 carriedStack) {
        player.method_17355(new ExtendedScreenHandlerFactory<AccessoriesMenuData>() {
            @Override
            public AccessoriesMenuData getScreenOpeningData(class_3222 player) {
                return AccessoriesMenuData.of(targetEntity, ((AccessoriesMenuBase) player.field_7512));
            }

            @Override
            public class_2561 method_5476() { return class_2561.method_43473(); }

            @Override
            public boolean shouldCloseCurrentScreen() {
                return false;
            }

            @Nullable
            @Override
            public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                return AccessoriesMenuVariant.openMenu(i, inventory, variant, targetEntity, carriedStack);
            }
        });
    }

    public static void addAttributeTooltips(@Nullable class_1657 player, class_1799 stack, Multimap<class_6880<class_1320>, class_1322> multimap, Consumer<class_2561> tooltipAddCallback, class_10712 display, class_1792.class_9635 context, class_1836 flag) {
        var itemAttributeDisplay = new class_9285.class_11193.class_11194();

        for (Map.Entry<class_6880<class_1320>, class_1322> entry : multimap.entries()) {
            itemAttributeDisplay.method_70731(tooltipAddCallback, player, entry.getKey(), entry.getValue());
        }
    }

    public static Function<class_3302.class_11558, class_7225.@Nullable class_7874> registerLoader(class_3264 packType, EndecDataLoader<?> dataLoader) {
        var loader = ResourceLoader.get(packType);

        var id = dataLoader.getId();

        loader.registerReloader(id, dataLoader);

        for (var dependencyId : dataLoader.getDependencyIds()) {
            loader.addReloaderOrdering(dependencyId, id);
        }

        return sharedState -> sharedState.method_72362(ResourceLoader.RELOADER_REGISTRY_LOOKUP_KEY);
    }
}
