package io.wispforest.accessories.fabric.client;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.client.renderers.BuiltinAccessoryRenderers;
import io.wispforest.accessories.client.AccessoriesClient;
import io.wispforest.accessories.client.AccessoriesPipelines;
import io.wispforest.accessories.client.AccessoriesRenderLayer;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.api.SyncedDataHelperManager;
import io.wispforest.accessories.fabric.AccessoriesFabric;
import io.wispforest.accessories.impl.core.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.event.AccessoriesEventHandler;
import io.wispforest.accessories.menu.AccessoriesMenuTypes;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.lookup.v1.entity.EntityApiLookup;
import net.minecraft.class_10042;
import net.minecraft.class_10712;
import net.minecraft.class_10799;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3929;
import net.minecraft.class_490;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import java.util.ArrayList;
import java.util.Map;

public class AccessoriesClientFabric implements ClientModInitializer {

    @Override
    public void onInitializeClient() {
        AccessoriesClient.initConfigStuff();
        AccessoriesClient.init();

        AccessoriesNetworking.initClient();
        SyncedDataHelperManager.initClient(AccessoriesNetworking.CHANNEL);

        AccessoriesMenuTypes.registerClientMenuConstructors(class_3929::method_17542);

        {
            var afterOthers = Accessories.of("accessories_after_others");

            ItemTooltipCallback.EVENT.addPhaseOrdering(Event.DEFAULT_PHASE, afterOthers);

            ItemTooltipCallback.EVENT.register(afterOthers, (stack, tooltipContext, tooltipType, lines) -> {
                var tooltipData = new ArrayList<class_2561>();

                var tooltipDisplay = stack.method_58695(class_9334.field_56400, class_10712.field_56318);

                AccessoriesEventHandler.getTooltipData(class_310.method_1551().field_1724, stack, tooltipData, tooltipDisplay, tooltipContext, tooltipType);

                if(!tooltipData.isEmpty()) lines.addAll(1, tooltipData);
            });
        }

        class_7923.field_41178.forEach(BuiltinAccessoryRenderers::onAddCallback);

//        RegistryEntryAddedCallback.event(BuiltInRegistries.ITEM).register((i, resourceLocation, item) -> {
//            BuiltinAccessoryRenderers.onAddCallback(item);
//        });


        KeyBindingHelper.registerKeyBinding(AccessoriesClient.OPEN_SCREEN);

        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (AccessoriesClient.OPEN_SCREEN.method_1436()){
                var player = client.field_1724;

                if (Accessories.config().screenOptions.prioritizeCreativeScreen() && player != null && player.method_68878()) {
                    if (client.field_1761.method_2895()) {
                        player.method_3132();
                    } else {
                        client.method_1577().method_4912();
                        client.method_1507(new class_490(player));
                    }

                    return;
                }

                AccessoriesClient.openScreenFromKey();
            }
        });

        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) -> {
            if(!(entityRenderer.method_4038() instanceof class_572)) return;

            // TODO: CONFIRM THIS IS CORRECT!
            var rendererCasted = (class_3883<class_10042, class_583<class_10042>>) entityRenderer;

            registrationHelper.register(new AccessoriesRenderLayer<>(rendererCasted));
        });

        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            for (class_1299<?> entityType : class_7923.field_41177) {
                var lookup = AccessoriesFabric.CAPABILITY;

                if(lookup.getProvider(entityType) != null) continue;

                lookup.registerForType((entity, unused) -> {
                    if(!(entity instanceof class_1309 livingEntity)) return null;

                    var slots = EntitySlotLoader.getEntitySlots(livingEntity);

                    if(slots.isEmpty()) return null;

                    return new AccessoriesCapabilityImpl(livingEntity);
                }, entityType);
            }

            AccessoriesClient.initalConfigDataSync();
        });

        AccessoriesPipelines.registerPipelines(class_10799::method_67887);
    }
}
