package io.wispforest.accessories.fabric.data;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.data.AccessoriesBaseData;
import io.wispforest.accessories.api.data.providers.entity.EntityBindingProvider;
import io.wispforest.accessories.api.data.providers.group.GroupDataProvider;
import io.wispforest.accessories.api.data.providers.slot.SlotDataProvider;
import io.wispforest.accessories.api.events.DropRule;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator.Pack;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7877;

public class AccessoriesDataGenEntrypoint implements DataGeneratorEntrypoint {

    @Override
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        var pack = fabricDataGenerator.createPack();

        if (true) return;

        pack.addProvider((fabricDataOutput, completableFuture) -> {
            return new SlotDataProvider(fabricDataOutput, completableFuture) {
                @Override
                protected void buildData(class_7225.class_7874 provider, SlotOutput output) {
                    var modid = "accessories";

                    output.accept(
                            modid,
                            this.builder("test")
                                    .amount(1)
                                    .dropRule(DropRule.KEEP)
                                    .create()
                    );
                }
            };
        });

        pack.addProvider((fabricDataOutput, completableFuture) -> {
            return new GroupDataProvider(fabricDataOutput, completableFuture) {
                @Override
                protected void buildData(class_7225.class_7874 provider, GroupOutput output) {
                    var modid = "accessories";

                    output.accept(
                            modid,
                            this.builder("test")
                                    .slots("test", AccessoriesBaseData.ANKLET_SLOT)
                                    .icon(Accessories.of("idk"))
                                    .order(1)
                                    .create()
                    );
                }
            };
        });

        pack.addProvider((fabricDataOutput, completableFuture) -> {
            return new EntityBindingProvider(fabricDataOutput, completableFuture){
                @Override
                protected void buildData(class_7225.class_7874 provider, EntityBindingOutput output) {
                    var modid = "accessories";

                    output.accept(
                            class_2960.method_60655(modid, "test_binding"),
                            this.builder()
                                    .slots("test")
                                    .entityType(class_1299.field_6097)
                                    .create()
                    );
                }
            };
        });
    }

    @Override
    public void buildRegistry(class_7877 registryBuilder) {
        DataGeneratorEntrypoint.super.buildRegistry(registryBuilder);

        UniqueSlotHandling.bootStrapDataGen(registryBuilder);
    }
}
