package io.wispforest.accessories.impl;

import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryNest;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotReference;
import org.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.class_1799;

public class AccessoryNestUtils {

    @Nullable
    public static AccessoryNestContainerContents getData(class_1799 stack){
        var accessory = AccessoryRegistry.getAccessoryOrDefault(stack);

        if(!(accessory instanceof AccessoryNest)) return null;

        return stack.method_58694(AccessoriesDataComponents.NESTED_ACCESSORIES);
    }

    public static <T, S extends SlotPath> @Nullable T recursiveStackHandling(class_1799 stack, S reference, BiFunction<class_1799, S, @Nullable T> function) {
        var accessory = AccessoryRegistry.getAccessoryOrDefault(stack);

        var value = function.apply(stack, reference);

        if (accessory instanceof AccessoryNest && value == null) {
            var data = getData(stack);

            if (data != null) {
                var innerStacks = data.accessories();

                for (int i = 0; i < innerStacks.size(); i++) {
                    var innerStack = innerStacks.get(i);

                    if (innerStack.method_7960()) continue;

                    value = recursiveStackHandling(innerStack, SlotPath.cloneWithInnerIndex(reference, i), function);

                    if(value != null) break;
                }

                if (reference instanceof SlotReference ref) {
                    AccessoryNest.checkIfChangesOccurred(stack, ref.entity(), data);
                }
            }
        }

        return value;
    }

    public static <S extends SlotPath> void recursiveStackConsumption(class_1799 stack, S reference, BiConsumer<class_1799, S> consumer) {
        var accessory = AccessoryRegistry.getAccessoryOrDefault(stack);

        consumer.accept(stack, reference);

        if (!(accessory instanceof AccessoryNest)) return;

        var data = getData(stack);

        if (data != null) {
            var innerStacks = data.accessories();

            for (int i = 0; i < innerStacks.size(); i++) {
                var innerStack = innerStacks.get(i);

                if (innerStack.method_7960()) continue;

                recursiveStackConsumption(innerStack, SlotPath.cloneWithInnerIndex(reference, i), consumer);
            }

            if (reference instanceof SlotReference ref) {
                AccessoryNest.checkIfChangesOccurred(stack, ref.entity(), data);
            }
        }
    }

    public static <S extends SlotPath> void recursiveStackConsumption(class_1799 stack, Consumer<class_1799> consumer) {
        var accessory = AccessoryRegistry.getAccessoryOrDefault(stack);

        consumer.accept(stack);

        if (!(accessory instanceof AccessoryNest)) return;

        var data = getData(stack);

        if (data != null) {
            var innerStacks = data.accessories();

            for (var innerStack : innerStacks) {
                if (innerStack.method_7960()) continue;

                recursiveStackConsumption(innerStack, consumer);
            }
        }
    }

}
