package io.wispforest.accessories.impl.event;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Sets.SetView;
import com.google.common.collect.UnmodifiableIterator;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers;
import io.wispforest.accessories.api.components.AccessoryItemAttributeModifiers.Builder;
import io.wispforest.accessories.api.components.AccessoryMobEffectsComponent;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryNest;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.events.*;
import io.wispforest.accessories.api.slot.*;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoryAttributeLogic;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.accessories.impl.core.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.core.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.impl.option.PlayerOptions;
import io.wispforest.accessories.impl.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.client.SyncContainerData;
import io.wispforest.accessories.networking.client.SyncEntireContainer;
import io.wispforest.accessories.networking.client.SyncPlayerOptions;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.endec.SerializationContext;
import io.wispforest.owo.serialization.RegistriesAttribute;
import it.unimi.dsi.fastutil.Pair;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.Map.Entry;
import java.util.stream.Collectors;

import static io.wispforest.accessories.Accessories.ACCESSORY_EQUIPPED;
import static io.wispforest.accessories.Accessories.ACCESSORY_UNEQUIPPED;

import I;
import Z;

@ApiStatus.Internal
public class AccessoriesEventHandler {

    public static boolean dataReloadOccurred = false;

    public static void onWorldTick(class_1937 level) {
        if (!(level instanceof class_3218 serverLevel)) return;

        revalidatePlayersOnReload(serverLevel.method_8503().method_3760());
    }

    public static void revalidatePlayersOnReload(class_3324 playerList) {
        if (!dataReloadOccurred) return;

        for (var player : playerList.method_14571()) revalidatePlayer(player);

        dataReloadOccurred = false;
    }

    public static void revalidatePlayer(class_3222 player) {
        var capability = AccessoriesCapability.get(player);

        if (capability == null) return;

        var validSlotTypes = EntitySlotLoader.getEntitySlots(player).values();

        var holderImpl = AccessoriesHolderImpl.getHolder(capability);

        holderImpl.setValidTypes(validSlotTypes.stream().map(SlotType::name).collect(Collectors.toSet()));

        for (var container : holderImpl.getAllSlotContainers().values()) {
            var slotType = container.slotType();

            if (slotType != null && validSlotTypes.contains(slotType)) {
                var baseSize = ((AccessoriesContainerImpl) container).getBaseSize();

                if (baseSize == null || baseSize != slotType.amount()) {
                    container.markChanged();
                    container.update();
                }

                var stacks = container.getAccessories();
                var cosmeticStacks = container.getCosmeticAccessories();

                for (int i = 0; i < container.getSize(); i++) {
                    var reference = container.createReference(i);

                    handleInvalidStacks(stacks, reference, player);
                    handleInvalidStacks(cosmeticStacks, reference, player);
                }
            } else {
                // TODO: DROP CONTAINER ?!
                var stacks = container.getAccessories();
                var cosmeticStacks = container.getCosmeticAccessories();

                for (int i = 0; i < container.getSize(); i++) {
                    var reference = container.createReference(i);

                    dropAndRemoveStack(stacks, reference, player);
                    dropAndRemoveStack(cosmeticStacks, reference, player);
                }
            }
        }
    }

    private static void handleInvalidStacks(class_1263 container, SlotReference reference, class_3222 player) {
        var stack = container.method_5438(reference.index());

        if (stack.method_7960()) return;

        var bl = !SlotPredicateRegistry.canInsertIntoSlot(stack, reference);

        if (bl) dropAndRemoveStack(container, reference, player);
    }

    private static void dropAndRemoveStack(class_1263 container, SlotReference reference, class_3222 player) {
        var stack = container.method_5438(reference.index());

        container.method_5447(reference.index(), class_1799.field_8037);

        AccessoriesInternals.giveItemToPlayer(player, stack);
    }

    public static void entityLoad(class_1309 entity, class_1937 level) {
        if (!level.method_8608() || !(entity instanceof class_3222 serverPlayer)) return;

        SyncEntireContainer.syncToAllTrackingAndSelf(serverPlayer);
    }

    public static void onTracking(class_1309 entity, class_3222 serverPlayer) {
        SyncEntireContainer.syncTo(entity, (packet) -> AccessoriesNetworking.sendToPlayer(serverPlayer, packet));
    }

    public static void dataSync(@Nullable class_3324 list, @Nullable class_3222 player) {
        if (list != null && !list.method_14571().isEmpty()) {
            revalidatePlayersOnReload(list);

            // TODO: OPTIMIZE THIS?
            for (var playerEntry : list.method_14571()) {
                var capability = AccessoriesCapability.get(playerEntry);

                if (capability == null) return;

                var carrier = NbtMapCarrier.of();

                AccessoriesHolderImpl.getHolder(capability).encode(carrier, SerializationContext.attributes(RegistriesAttribute.of(playerEntry.method_51469().method_30349())));

                AccessoriesNetworking.sendToTrackingAndSelf(playerEntry, new SyncEntireContainer(capability.entity().method_5628(), carrier));

                if (playerEntry.field_7512 instanceof AccessoriesMenuBase base) {
                    Accessories.openAccessoriesMenu(playerEntry, base.menuVariant(), base.targetEntity());
                }
            }
        } else if (player != null) {
            revalidatePlayer(player);

            var capability = AccessoriesCapability.get(player);

            if (capability == null) return;

            var carrier = NbtMapCarrier.of();

            AccessoriesHolderImpl.getHolder(capability).encode(carrier, SerializationContext.attributes(RegistriesAttribute.of(player.method_51469().method_30349())));

            AccessoriesNetworking.sendToPlayer(player, new SyncEntireContainer(capability.entity().method_5628(), carrier));

            AccessoriesNetworking.sendToPlayer(player, new SyncPlayerOptions(AccessoriesPlayerOptionsHolder.getOptions(player)));

            if (player.field_7512 instanceof AccessoriesMenuBase base) {
                Accessories.openAccessoriesMenu(player, base.menuVariant(), base.targetEntity());
            }
        }

        AccessoriesHolderImpl.clearValidationCache(false);
    }

    public static void onLivingEntityTick(class_1309 entity) {
        if (entity.method_31481()) return;

        var capability = AccessoriesCapability.get(entity);

        if (capability != null) {
            var dirtyStacks = new HashMap<String, class_1799>();
            var dirtyCosmeticStacks = new HashMap<String, class_1799>();

            var removedAttributesBuilder = new AccessoryAttributeBuilder();
            var addedAttributesBuilder = new AccessoryAttributeBuilder();

            for (var containerEntry : AccessoriesHolderImpl.getHolder(capability).getAllSlotContainers().entrySet()) {
                var container = containerEntry.getValue();

                var accessories = container.getAccessories();
                var cosmetics = container.getCosmeticAccessories();

                for (int i = 0; i < accessories.method_5439(); i++) {
                    var slotReference = container.createReference(i);

                    var slotId = container.getSlotName() + "/" + i;

                    var currentStack = accessories.method_5438(i);

                    // TODO: Move ticking below checks?
                    if (!currentStack.method_7960()) {
                        // TODO: Document this behavior to prevent double ticking maybe!!!
                        currentStack.method_7917(entity.method_73183(), entity, null);

                        var accessory = AccessoryRegistry.getAccessoryOrDefault(currentStack);

                        if (accessory != null) {
                            accessory.tick(currentStack, slotReference);

                            AccessoryNestUtils.recursiveStackConsumption(currentStack, stack -> {
                                var effects = stack.method_58694(AccessoriesDataComponents.MOB_EFFECTS);

                                if (effects != null) {
                                    effects.handleReapplyingEffects(entity, entity.method_73183().method_8510());
                                }
                            });
                        }
                    }

                    var lastStack = accessories.getPreviousItem(i);
                    var flagged = accessories.isSlotFlagged(i);

                    // Prevent attribute related logic on the client and if the entity
                    // is dead as such data should not be updated. Though we allow for
                    // ticking to occur at least for vanilla parity I guess.
                    if (entity.method_73183().method_8608() || entity.method_29504()) continue;

                    if (!class_1799.method_7973(currentStack, lastStack) || flagged) {
                        if (!lastStack.method_7960()) {
                            var removedEnchantmentBuilder = new AccessoryAttributeBuilder(slotReference);

                            // TODO: MAYBE MOVE THIS TO AccessoryAttributeLogic or something
                            class_1890.method_60140(lastStack, AccessoriesInternals.INTERNAL_SLOT, (attributeHolder, modifier) -> {
                                var namespace = modifier.comp_2447().method_12836();
                                var splitPath = new ArrayList<>(List.of(modifier.comp_2447().method_12832().split("/")));

                                splitPath.removeLast();

                                removedEnchantmentBuilder.addStackable(attributeHolder, new class_1322(class_2960.method_60655(namespace, String.join("/", splitPath)), modifier.comp_2449(), modifier.comp_2450()));
                            });

                            removedAttributesBuilder.addFrom(removedEnchantmentBuilder);
                            removedAttributesBuilder.addFrom(AccessoryAttributeLogic.getAttributeModifiers(lastStack, slotReference));

                            ((AccessoriesLivingEntityExtension) entity).pushEnchantmentContext(lastStack, slotReference);
                            class_1890.method_60141(lastStack, entity, AccessoriesInternals.INTERNAL_SLOT);
                        }

                        if (!currentStack.method_7960()) {
                            var addedEnchantmentBuilder = new AccessoryAttributeBuilder(slotReference);

                            class_1890.method_60140(currentStack, AccessoriesInternals.INTERNAL_SLOT, (attributeHolder, modifier) -> {
                                var namespace = modifier.comp_2447().method_12836();
                                var splitPath = new ArrayList<>(List.of(modifier.comp_2447().method_12832().split("/")));

                                splitPath.removeLast();

                                addedEnchantmentBuilder.addStackable(attributeHolder, new class_1322(class_2960.method_60655(namespace, String.join("/", splitPath)), modifier.comp_2449(), modifier.comp_2450()));
                            });

                            addedAttributesBuilder.addFrom(addedEnchantmentBuilder);
                            addedAttributesBuilder.addFrom(AccessoryAttributeLogic.getAttributeModifiers(currentStack, slotReference));

                            ((AccessoriesLivingEntityExtension) entity).pushEnchantmentContext(currentStack, slotReference);
                            class_1890.method_60125((class_3218) entity.method_73183(), currentStack, entity, AccessoriesInternals.INTERNAL_SLOT);
                        }

                        AccessoryNestUtils.recursiveStackConsumption(lastStack, stack -> {
                            if (stack.method_57826(AccessoriesDataComponents.MOB_EFFECTS)) {
                                stack.method_58694(AccessoriesDataComponents.MOB_EFFECTS)
                                    .handleRemovingEffects(entity);
                            }
                        });

                        AccessoryNestUtils.recursiveStackConsumption(currentStack, stack -> {
                            if (stack.method_57826(AccessoriesDataComponents.MOB_EFFECTS)) {
                                stack.method_58694(AccessoriesDataComponents.MOB_EFFECTS)
                                    .handleApplyingConstantEffects(entity);
                            }
                        });

                        boolean equipmentChange = false;

                        /*
                         * TODO: Does item check need to exist anymore?
                         */
                        if (!class_1799.method_7984(currentStack, lastStack) || flagged) {
                            AccessoryRegistry.getAccessoryOrDefault(lastStack).onUnequip(lastStack, slotReference);
                            AccessoryRegistry.getAccessoryOrDefault(currentStack).onEquip(currentStack, slotReference);

                            if (entity instanceof class_3222 serverPlayer) {
                                if (!currentStack.method_7960()) {
                                    ACCESSORY_EQUIPPED.trigger(serverPlayer, currentStack, slotReference, false);
                                }

                                if (!lastStack.method_7960()) {
                                    ACCESSORY_UNEQUIPPED.trigger(serverPlayer, lastStack, slotReference, false);
                                }
                            }

                            equipmentChange = true;
                        }

                        AccessoryChangeCallback.EVENT.invoker().onChange(lastStack, currentStack, slotReference, equipmentChange ? SlotStateChange.REPLACEMENT : SlotStateChange.MUTATION);

                        container.getAccessories().setPreviousItem(i, currentStack);
                        dirtyStacks.put(slotId, currentStack.method_7972());

                        recursiveStackChange(slotReference, AccessoryNestUtils.getData(lastStack), AccessoryNestUtils.getData(currentStack));
                    }

                    var currentCosmeticStack = cosmetics.method_5438(i);
                    var lastCosmeticStack = container.getCosmeticAccessories().getPreviousItem(i);

                    if (!class_1799.method_7973(currentCosmeticStack, lastCosmeticStack)) {
                        cosmetics.setPreviousItem(i, currentCosmeticStack);
                        dirtyCosmeticStacks.put(slotId, currentCosmeticStack.method_7972());

                        if (entity instanceof class_3222 serverPlayer) {
                            if (!currentStack.method_7960()) {
                                ACCESSORY_EQUIPPED.trigger(serverPlayer, currentStack, slotReference, true);
                            }
                            if (!lastStack.method_7960()) {
                                ACCESSORY_UNEQUIPPED.trigger(serverPlayer, lastStack, slotReference, true);
                            }
                        }
                    }
                }
            }

            if (entity.method_73183().method_8608()) return;

            AttributeUtils.removeTransientAttributeModifiers(entity, removedAttributesBuilder);
            AttributeUtils.addTransientAttributeModifiers(entity, addedAttributesBuilder);

            //--
            var updatedContainers = AccessoriesHolderImpl.getHolder(capability).containersRequiringUpdates();

            capability.updateContainers();

            ContainersChangeCallback.EVENT.invoker().onChange(entity, capability, ImmutableMap.copyOf(updatedContainers));

            if (!dirtyStacks.isEmpty() || !dirtyCosmeticStacks.isEmpty() || !updatedContainers.isEmpty()) {
                var packet = SyncContainerData.of(entity, updatedContainers.keySet(), dirtyStacks, dirtyCosmeticStacks);

                AccessoriesNetworking.sendToTrackingAndSelf(entity, packet);
            }

            updatedContainers.clear();
        }

        //--

        var holder = ((AccessoriesHolderImpl) AccessoriesInternals.getHolder(entity));

        // Fix for holder data not being loaded so invalid stacks can be collected
        if (holder.loadedFromTag() && capability == null) {
            var tempCapability = new AccessoriesCapabilityImpl(entity);
        }

        var invalidStacks = (holder).invalidStacks;

        if (!invalidStacks.isEmpty() && entity.method_73183() instanceof class_3218 serverLevel) {
            for (class_1799 invalidStack : invalidStacks) {
                if (entity instanceof class_3222 serverPlayer) {
                    AccessoriesInternals.giveItemToPlayer(serverPlayer, invalidStack);
                } else {
                    entity.method_5775(serverLevel, invalidStack);
                }
            }

            invalidStacks.clear();
        }
    }

    private static void recursiveStackChange(SlotReference slotReference, @Nullable AccessoryNestContainerContents lastNestData, @Nullable AccessoryNestContainerContents currentNestData) {
        var currentNestChanges = (currentNestData != null)
                ? currentNestData.slotChanges()
                : new HashMap<Integer, SlotStateChange>();

        var lastInnerStacks = lastNestData != null ? List.copyOf(lastNestData.getMap(slotReference).entrySet()) : List.<Map.Entry<SlotEntryReference, Accessory>>of();
        var currentInnerStacks = currentNestData != null ? List.copyOf(currentNestData.getMap(slotReference).entrySet()) : List.<Map.Entry<SlotEntryReference, Accessory>>of();

        var maxIterationLength = Math.max(lastInnerStacks.size(), currentInnerStacks.size());

        for (int i = 0; i < maxIterationLength; i++) {
            var lastInnerEntry = (i < lastInnerStacks.size()) ? lastInnerStacks.get(i) : null;
            var currentInnerEntry = (i < currentInnerStacks.size()) ? currentInnerStacks.get(i) : null;

            var changeType = currentNestChanges.getOrDefault(i, SlotStateChange.REPLACEMENT);

            if (lastInnerEntry == null && currentInnerEntry != null) {
                var currentRef = currentInnerEntry.getKey();
                var currentInnerStack = currentRef.stack();

                onStackChange(currentRef.reference(), class_1799.field_8037, currentRef.stack(), changeType);

                recursiveStackChange(slotReference, null, AccessoryNestUtils.getData(currentInnerStack));
            } else if (currentInnerEntry == null && lastInnerEntry != null) {
                var lastRef = lastInnerEntry.getKey();
                var lastInnerStack = lastRef.stack();

                onStackChange(lastRef.reference(), lastRef.stack(), class_1799.field_8037, changeType);

                recursiveStackChange(slotReference, AccessoryNestUtils.getData(lastInnerStack), null);
            } else if (lastInnerEntry != null && currentInnerEntry != null) {
                var currentRef = currentInnerEntry.getKey();
                var lastRef = lastInnerEntry.getKey();

                var innerRef = lastRef.reference();

                var currentInnerStack = currentRef.stack();
                var lastInnerStack = lastRef.stack();

                onStackChange(innerRef, lastInnerStack, currentInnerStack, changeType);

                recursiveStackChange(slotReference, AccessoryNestUtils.getData(lastInnerStack), AccessoryNestUtils.getData(currentInnerStack));
            }
        }

        currentNestChanges.clear();
    }

    private static void onStackChange(SlotReference slotReference, class_1799 lastStack, class_1799 currentStack, SlotStateChange stateChange) {
        if (slotReference.entity() instanceof class_3222 serverPlayer) {
            if (!currentStack.method_7960()) {
                ACCESSORY_EQUIPPED.trigger(serverPlayer, currentStack, slotReference, false);
            }

            if (!lastStack.method_7960()) {
                ACCESSORY_UNEQUIPPED.trigger(serverPlayer, lastStack, slotReference, false);
            }
        }

        AccessoryChangeCallback.EVENT.invoker().onChange(lastStack, currentStack, slotReference, stateChange);
    }

    public static void getTooltipData(@Nullable class_1309 entity, class_1799 stack, List<class_2561> tooltip,class_10712 display, class_1792.class_9635 tooltipContext, class_1836 tooltipType) {
        var accessory = AccessoryRegistry.getAccessoryOrDefault(stack);

        if (accessory != null) {
            if (entity != null && AccessoriesCapability.get(entity) != null)
                addEntityBasedTooltipData(entity, accessory, stack, tooltip, display, tooltipContext, tooltipType);

            accessory.getExtraTooltip(stack, tooltip, tooltipContext, tooltipType);
        }
    }

    // TODO: Rewrite for better handling of various odd cases
    private static void addEntityBasedTooltipData(class_1309 entity, Accessory accessory, class_1799 stack, List<class_2561> tooltip, class_10712 display, class_1792.class_9635 tooltipContext, class_1836 tooltipType) {
        // TODO: MAYBE DEPENDING ON ENTITY OR SOMETHING SHOW ALL VALID SLOTS BUT COLOR CODE THEM IF NOT VALID FOR ENTITY?
        // TODO: ADD BETTER HANDLING FOR POSSIBLE SLOTS THAT ARE EQUIPABLE IN BUT IS AT ZERO SIZE
        var validSlotTypes = new HashSet<>(SlotPredicateRegistry.getValidSlotTypes(entity, stack));

        if (validSlotTypes.isEmpty()) return;

        {
            final var validUniqueSlots = new HashSet<SlotType>();

            validSlotTypes.removeIf(slotType -> {
                var isUnique = UniqueSlotHandling.isUniqueSlot(slotType.name());

                if(isUnique) validUniqueSlots.add(slotType);

                return isUnique;
            });

            var sharedSlotTypes = SlotTypeLoader.INSTANCE.getEntries(entity.method_73183()).values()
                    .stream()
                    .filter(slotType -> !UniqueSlotHandling.isUniqueSlot(slotType.name()))
                    .collect(Collectors.toSet());

            var slotInfoComponent = class_2561.method_43470("");

            var slotsComponent = class_2561.method_43470("");
            boolean allSlots = false;

            if (validSlotTypes.containsAll(sharedSlotTypes)) {
                slotsComponent.method_10852(class_2561.method_43471(Accessories.translationKey("slot.any")));
                allSlots = true;
            } else {
                var entitySlotTypes = Set.copyOf(EntitySlotLoader.getEntitySlots(entity).values());

                var invalidSlotsTypes = Sets.difference(entitySlotTypes, validSlotTypes);

                if (invalidSlotsTypes.size() < validSlotTypes.size()) {
                    slotsComponent.method_10852(class_2561.method_43471(Accessories.translationKey("slot.any")));
                    slotsComponent.method_10852(class_2561.method_43471(Accessories.translationKey("slot.except")).method_27692(class_124.field_1080));

                    var invalidSlotsItr = invalidSlotsTypes.iterator();

                    while(invalidSlotsItr.hasNext()) {
                        var type = invalidSlotsItr.next();

                        if (ExtraSlotTypeProperties.getProperty(type.name(), entity.method_73183().method_8608()).allowTooltipInfo()) {
                            slotsComponent.method_10852(class_2561.method_43471(type.translation()).method_27692(class_124.field_1061));

                            if (invalidSlotsItr.hasNext()) {
                                slotsComponent.method_10852(class_2561.method_43470(", ").method_27692(class_124.field_1080));
                            }
                        }
                    }
                } else {
                    var validSlotsItr = validSlotTypes.iterator();

                    while(validSlotsItr.hasNext()) {
                        var type = validSlotsItr.next();

                        if (ExtraSlotTypeProperties.getProperty(type.name(), entity.method_73183().method_8608()).allowTooltipInfo()) {
                            slotsComponent.method_10852(class_2561.method_43471(type.translation()));

                            if (validSlotsItr.hasNext()) {
                                slotsComponent.method_10852(class_2561.method_43470(", ").method_27692(class_124.field_1080));
                            }
                        }
                    }
                }
            }

            validSlotTypes.addAll (validUniqueSlots);

            final var filteredValidUniqueSlots = validUniqueSlots.stream()
                    .filter(slotType -> ExtraSlotTypeProperties.getProperty(slotType.name(), true).allowTooltipInfo())
                    .toList();

            if (!filteredValidUniqueSlots.isEmpty()) {
                var uniqueItr = filteredValidUniqueSlots.iterator();

                while(uniqueItr.hasNext()) {
                    var type = uniqueItr.next();

                    slotsComponent.method_10852(class_2561.method_43471(type.translation()));

                    if(uniqueItr.hasNext()) {
                        slotsComponent.method_10852(class_2561.method_43470(", ").method_27692(class_124.field_1080));
                    }
                }
            }

            if(!slotsComponent.method_10855().isEmpty()) {
                var slotTranslationKey = "slot.tooltip." + ((validSlotTypes.size() > 1 && !allSlots) ? "plural" : "singular");

                slotInfoComponent.method_10852(
                        class_2561.method_43471(Accessories.translationKey(slotTranslationKey))
                                .method_27692(class_124.field_1080)
                                .method_10852(slotsComponent.method_27692(class_124.field_1078))
                );

                tooltip.add(slotInfoComponent);
            }
        }

        var slotSpecificModifiers = new HashMap<SlotType, AccessoryAttributeBuilder>();
        AccessoryAttributeBuilder defaultModifiers = null;

        boolean allDuplicates = true;

        for (var slotType : validSlotTypes) {
            var reference = SlotReference.of(entity, slotType.name(), 0);

            var builder = AccessoryAttributeLogic.getAttributeModifiers(stack, reference, true);

            if (builder.isEmpty()) continue;

            slotSpecificModifiers.put(slotType, builder);

            if (defaultModifiers == null) {
                defaultModifiers = builder;
            } else if (allDuplicates) {
                // TODO: ! WARNING ! THIS MAY NOT WORK?
                allDuplicates = defaultModifiers.equals(builder);
            }
        }

        var slotTypeToTooltipInfo = new HashMap<SlotType, List<class_2561>>();

        if (allDuplicates) {
            if (defaultModifiers != null && !defaultModifiers.isEmpty()) {
                var attributeTooltip = new ArrayList<class_2561>();

                addAttributeTooltip(entity, stack, defaultModifiers.getAttributeModifiers(false), attributeTooltip, display, tooltipContext, tooltipType);

                slotTypeToTooltipInfo.put(null, attributeTooltip);
            }
        } else {
            for (var slotModifiers : slotSpecificModifiers.entrySet()) {
                var slotType = slotModifiers.getKey();
                var modifiers = slotModifiers.getValue();

                var attributeTooltip = new ArrayList<class_2561>();

                addAttributeTooltip(entity, stack, modifiers.getAttributeModifiers(false), attributeTooltip, display, tooltipContext, tooltipType);

                slotTypeToTooltipInfo.put(slotType, attributeTooltip);
            }
        }

        var extraAttributeTooltips = new HashMap<SlotType, List<class_2561>>();
        List<class_2561> defaultExtraAttributeTooltip = null;

        boolean allDuplicatesExtras = true;

        for (var slotType : validSlotTypes) {
            var extraAttributeTooltip = new ArrayList<class_2561>();
            accessory.getAttributesTooltip(stack, slotType, extraAttributeTooltip, tooltipContext, tooltipType);

            extraAttributeTooltips.put(slotType, extraAttributeTooltip);

            if (defaultExtraAttributeTooltip == null) {
                defaultExtraAttributeTooltip = extraAttributeTooltip;
            } else if (allDuplicatesExtras) {
                allDuplicatesExtras = extraAttributeTooltip.equals(defaultExtraAttributeTooltip);
            }
        }

        if (allDuplicatesExtras) {
            if (defaultExtraAttributeTooltip != null) {
                slotTypeToTooltipInfo.computeIfAbsent(null, s -> new ArrayList<>())
                    .addAll(defaultExtraAttributeTooltip);
            }
        } else {
            extraAttributeTooltips.forEach((slotType, components) -> {
                slotTypeToTooltipInfo.computeIfAbsent(slotType, s -> new ArrayList<>())
                        .addAll(components);
            });
        }

        if (slotTypeToTooltipInfo.containsKey(null)) {
            var anyTooltipInfo = slotTypeToTooltipInfo.get(null);

            if (!anyTooltipInfo.isEmpty()) {
                tooltip.add(class_5244.field_39003);

                tooltip.add(
                        class_2561.method_43471(Accessories.translationKey("tooltip.attributes.any"))
                                .method_27692(class_124.field_1080)
                );

                tooltip.addAll(anyTooltipInfo);
            }

            slotTypeToTooltipInfo.remove(null);
        }

        if (!slotTypeToTooltipInfo.isEmpty()) {
            for (var entry : slotTypeToTooltipInfo.entrySet()) {
                var tooltipData = entry.getValue();

                if (tooltipData.isEmpty()) continue;

                tooltip.add(class_5244.field_39003);

                tooltip.add(
                        class_2561.method_43469(
                                Accessories.translationKey("tooltip.attributes.slot"),
                                class_2561.method_43471(entry.getKey().translation()).method_27692(class_124.field_1078)
                        ).method_27692(class_124.field_1080)
                );

                tooltip.addAll(entry.getValue());
            }
        }
    }

    private static void addAttributeTooltip(class_1309 entity, class_1799 stack, Multimap<class_6880<class_1320>, class_1322> multimap, List<class_2561> tooltip, class_10712 display, class_1792.class_9635 context, class_1836 flag) {
        if (multimap.isEmpty()) return;

        AccessoriesInternals.addAttributeTooltips((entity instanceof class_1657 player ? player : null), stack, multimap, tooltip::add, display, context, flag);
    }

    @Nullable
    public static Collection<class_1799> onDeath(class_1309 entity, class_1282 source) {
        var capability = AccessoriesCapability.get(entity);

        if (capability == null) return List.of();

        var droppedStacks = new ArrayList<class_1799>();

        var gamerules = ((class_3218) entity.method_73183()).method_64395();

        var keepInv = gamerules.method_20746(class_1928.field_19389).method_20753() || gamerules.method_20746(Accessories.RULE_KEEP_ACCESSORY_INVENTORY).method_20753();

        for (var containerEntry : AccessoriesHolderImpl.getHolder(capability).getAllSlotContainers().entrySet()) {
            var slotType = containerEntry.getValue().slotType();

            var slotDropRule = slotType != null ? slotType.dropRule() : DropRule.DEFAULT;

            var container = containerEntry.getValue();

            var stacks = container.getAccessories();
            var cosmeticStacks = container.getCosmeticAccessories();

            for (int i = 0; i < container.getSize(); i++) {
                var reference = SlotReference.of(entity, container.getSlotName(), i);

                var stack = dropStack(slotDropRule, entity, stacks, reference, source, keepInv);
                if (stack != null) droppedStacks.add(stack);

                var cosmeticStack = dropStack(slotDropRule, entity, cosmeticStacks, reference, source, keepInv);
                if (cosmeticStack != null) droppedStacks.add(cosmeticStack);
            }
        }

        var result = OnDeathCallback.EVENT.invoker().shouldDrop(TriState.DEFAULT, entity, capability, source, droppedStacks);

        if (!result.orElse(true)) return null;

        return droppedStacks;
    }

    @Nullable
    private static class_1799 dropStack(DropRule dropRule, class_1309 entity, ExpandedContainer container, SlotReference reference, class_1282 source, boolean keepInvEnabled) {
        var stack = container.method_5438(reference.index());

        if (stack.method_7960()) return null;

        var accessory = AccessoryRegistry.getAccessoryOrDefault(stack);

        if (accessory != null && dropRule == DropRule.DEFAULT) {
            dropRule = accessory.getDropRule(stack, reference, source);
        }

        if (accessory instanceof AccessoryNest holdable) {
            var dropRuleToStacks = holdable.getDropRules(stack, reference, source);

            for (int i = 0; i < dropRuleToStacks.size(); i++) {
                var rulePair = dropRuleToStacks.get(i);

                var innerStack = rulePair.right();

                var result = OnDropCallback.getAlternativeRule(rulePair.left(), innerStack, reference, source);

                var breakInnerStack = (result == DropRule.DEFAULT && class_1890.method_60142(innerStack, class_9701.field_51655))
                        || (result == DropRule.DESTROY);

                if (breakInnerStack) {
                    holdable.setInnerStack(stack, i, class_1799.field_8037);
                    // TODO: Do we call break here for the accessory?

                    container.method_5447(reference.index(), stack);
                }
            }
        }

        var result = OnDropCallback.getAlternativeRule(dropRule, stack, reference, source);

        boolean dropStack = true;
        boolean keepingStack = false;

        if (result == DropRule.DESTROY) {
            container.method_5447(reference.index(), class_1799.field_8037);
            dropStack = false;
            // TODO: Do we call break here for the accessory?
        } else if (result == DropRule.KEEP) {
            dropStack = false;
            keepingStack = true;
        } else if (result == DropRule.DEFAULT) {
            if (keepInvEnabled) {
                dropStack = false;

                keepingStack = true;
            } else if (class_1890.method_60142(stack, class_9701.field_51655)) {
                container.method_5447(reference.index(), class_1799.field_8037);
                dropStack = false;
                // TODO: Do we call break here for the accessory?
            }
        }

        // Used to indicate within the Accessories system when the player becomes alive that we need to
        // equip the accessory again to trigger equip call and properly add back Attributes
        if (keepingStack) {
            container.setPreviousItem(reference.index(), class_1799.field_8037);
        }

        if (!dropStack) return null;

        container.method_5447(reference.index(), class_1799.field_8037);

        return stack;
    }

    public static class_1269 attemptEquipFromUse(class_1657 player, class_1268 hand) {
        var stack = player.method_5998(hand);

        var capability = AccessoriesCapability.get(player);

        if (capability != null && !player.method_7325() && !stack.method_7960()) {
            var equipControl = AccessoriesPlayerOptionsHolder.getOptions(player).getDefaultedData(PlayerOptions.EQUIP_CONTROL);

            var shouldAttemptEquip = false;

            if (equipControl == PlayerEquipControl.MUST_CROUCH && player.method_5715()) {
                shouldAttemptEquip = true;
            } else if (equipControl == PlayerEquipControl.MUST_NOT_CROUCH && !player.method_5715()) {
                shouldAttemptEquip = true;
            }

            if (shouldAttemptEquip) {
                var accessory = AccessoryRegistry.getAccessoryOrDefault(stack);

                var equipReference = capability.canEquipAccessory(stack, true);

                if (equipReference != null && accessory.canEquipFromUse(stack, equipReference.left())) {
                    accessory.onEquipFromUse(stack, equipReference.left());

                    var newHandStack = stack.method_7972();

                    var possibleSwappedStack = equipReference.second().equipStack(newHandStack);

                    if (possibleSwappedStack.isPresent()) {
                        var swappedStack = possibleSwappedStack.get();

                        if (newHandStack.method_7960()) {
                            newHandStack = swappedStack;
                        } else if (class_1799.method_31577(newHandStack, swappedStack) && (newHandStack.method_7947() + swappedStack.method_7947()) <= newHandStack.method_7914()) {
                            newHandStack.method_7933(swappedStack.method_7947());
                        } else {
                            player.method_7270(swappedStack);
                        }
                    }

                    return class_1269.field_5812.method_61393(newHandStack);
                }
            }
        }

        return class_1269.field_5811;
    }

    public static class_1269 attemptEquipOnEntity(class_1657 player, class_1268 hand, class_1297 entity) {
        var stack = player.method_5998(hand);

        if (!(entity instanceof class_1309 targetEntity) || !entity.method_5864().method_20210(AccessoriesTags.EQUIPMENT_MANAGEABLE))
            return class_1269.field_5811;

        var targetCapability = AccessoriesCapability.get(targetEntity);

        var canModify = AllowEntityModificationCallback.EVENT.invoker().allowModifications(targetEntity, player, null).orElse(false);

        if (canModify && targetCapability != null && !player.method_7325()) {
            if (player.method_5715()) {
                var accessory = AccessoryRegistry.getAccessoryOrDefault(stack);

                var equipReference = targetCapability.canEquipAccessory(stack, true);

                if (equipReference != null && accessory.canEquipFromUse(stack, equipReference.left())) {
                    if (!stack.method_7960()) accessory.onEquipFromUse(stack, equipReference.left());

                    var newHandStack = stack.method_7972();

                    var possibleSwappedStack = equipReference.second().equipStack(newHandStack);

                    if (possibleSwappedStack.isPresent()) {
                        var swappedStack = possibleSwappedStack.get();

                        if (newHandStack.method_7960()) {
                            newHandStack = swappedStack;
                        } else if (class_1799.method_31577(newHandStack, swappedStack) && (newHandStack.method_7947() + swappedStack.method_7947()) <= newHandStack.method_7914()) {
                            newHandStack.method_7933(swappedStack.method_7947());
                        } else {
                            player.method_7270(swappedStack);
                        }
                    }

                    return class_1269.field_5812.method_61393(newHandStack);
                }
            }
        }

        return class_1269.field_5811;
    }

    public static void setupItems(AddDataComponentCallback callback) {
        AccessoryRegistry.getAllAccessories().forEach((item, accessory) -> {
            var builder = AccessoryItemAttributeModifiers.builder();

            accessory.getStaticModifiers(item, builder);

            if (!builder.isEmpty()) {
                callback.addTo(item, AccessoriesDataComponents.ATTRIBUTES, builder.build());
            }
        });
    }

    public interface AddDataComponentCallback {
        <T> void addTo(class_1792 item, class_9331<T> componentType, T component);
    }
}
