package io.wispforest.accessories.impl.event;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.slot.SlotBasedPredicate;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import java.util.List;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1746;
import net.minecraft.class_9334;

public class VanillaItemPredicates {
    public static final SlotBasedPredicate ELYTRA_PREDICATE = (level, slotType, slot, stack) -> {
        var validSlots = Accessories.config().contentOptions.validGliderSlots();

        if (stack.method_57826(class_9334.field_54197)) {
            if ((validSlots.contains(slotType.name()) || validSlots.contains("any")) && Accessories.config().contentOptions.allowGliderEquip()) {
                return TriState.TRUE;
            } else if (slotType.name().equals("cape") && stack.method_31573(AccessoriesTags.VALID_GLIDER_EQUIP)){
                return TriState.TRUE;
            }
        }

        return TriState.DEFAULT;
    };

    public static final SlotBasedPredicate TOTEM_PREDICATE = (level, slotType, slot, stack) -> {
        var validSlots = Accessories.config().contentOptions.validTotemSlots();

        if(stack.method_57826(class_9334.field_54274)) {
            if ((validSlots.contains(slotType.name()) || validSlots.contains("any")) && Accessories.config().contentOptions.allowTotemEquip()) {
                return TriState.TRUE;
            } else if (slotType.name().equals("charm") && stack.method_31573(AccessoriesTags.VALID_TOTEM_EQUIP)){
                return TriState.TRUE;
            }
        }

        return TriState.DEFAULT;
    };

    public static final SlotBasedPredicate BANNER_PREDICATE = (level, slotType, slot, stack) -> {
        var validSlots = Accessories.config().contentOptions.validBannerSlots();

        if(stack.method_7909() instanceof class_1746) {
            if ((validSlots.contains(slotType.name()) || validSlots.contains("any")) && Accessories.config().contentOptions.allowBannerEquip()) {
                return TriState.TRUE;
            }
        }

        return TriState.DEFAULT;
    };

    public static void init() {
        SlotPredicateRegistry.register(Accessories.of("elytra_item"), ELYTRA_PREDICATE);
        SlotPredicateRegistry.register(Accessories.of("totem_item"), TOTEM_PREDICATE);
        SlotPredicateRegistry.register(Accessories.of("banner_item"), BANNER_PREDICATE);
    }
}
