package io.wispforest.accessories.impl.slot;

import Z;
import com.google.common.collect.Lists;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryNest;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotPath;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

@ApiStatus.Internal
public record SlotReferenceImpl(class_1309 entity, SlotPath slotPath) implements SlotReference {
    public SlotReferenceImpl {
        if(slotPath.index() < -1) {
            throw new IndexOutOfBoundsException("A given Slot Reference was attempted to be created with a negative index!");
        }
    }

    //--

    @Override
    public boolean isValid() {
        var capability = this.capability();

        if(capability == null) return false;

        var container = capability.getContainers().get(this.slotName());

        if(container == null) return false;

        var invContainer = container.getAccessories();

        var validIndex = invContainer.validIndex(index());

        // If Valid index and not NestedSlotPath then we can just use the result
        // or if invalid index and is nested then just return the false result
        if (!(slotPath.isNested()) || !validIndex) return validIndex;

        var selectedStack = container.getAccessories().method_5438(index());

        for (var innerSlotIndex : slotPath.innerIndices()) {
            var nestLayer = tryAndGet(selectedStack, innerSlotIndex);

            if(nestLayer == null) return false;

            selectedStack = nestLayer.getInnerStack();
        }

        return true;
    }

    @Override
    @Nullable
    public class_1799 getStack() {
        var container = this.slotContainer();

        if(container == null) return null;

        var invContainer = container.getAccessories();

        if (!invContainer.validIndex(index())) return null;

        var selectedStack = invContainer.method_5438(index());

        // If not a NestedSlotPath then return the stack
        // but if we are then we will need to go though the paths inner indices
        if (!(slotPath.isNested())) return selectedStack;

        for (var innerSlotIndex : slotPath.innerIndices()) {
            var nestLayer = tryAndGet(selectedStack, innerSlotIndex);

            if(nestLayer == null) return null;

            selectedStack = nestLayer.getInnerStack();
        }

        return selectedStack;
    }

    @Nullable
    private static NestLayer tryAndGet(class_1799 holderStack, int innerIndex) {
        var accessory = AccessoryRegistry.getAccessoryOrDefault(holderStack);

        return (accessory instanceof AccessoryNest accessoryNest)
                ? new NestLayer(accessoryNest, holderStack, innerIndex)
                : null;
    }

    @Override
    public boolean setStack(class_1799 stack) {
        var container = this.slotContainer();

        if(container == null) return false;

        var invContainer = container.getAccessories();

        if (!invContainer.validIndex(index())) return false;

        if (!(slotPath.isNested())) {
            invContainer.method_5447(index(), stack);

            return true;
        }

        var baseStack = invContainer.method_5438(index());

        var layerStack = new ArrayList<NestLayer>();

        // First we build the Nest Layer stack for how far the innerSlotIndices go i.e. tracking how many nests deep we go
        for (var innerSlotIndex : slotPath.innerIndices()) {
            var layer = tryAndGet(baseStack, innerSlotIndex);

            if(layer == null) return false;

            layerStack.add(layer);
            baseStack = layer.getInnerStack();
        }

        var innerStack = stack;

        // Second we reverse the list of layers getting the most inner nest target and work are way out setting the stack to
        // properly track data component updates
        for (var layer : Lists.reverse(layerStack)){
            if(!layer.setInnerStack(innerStack)) return false;

            innerStack = layer.holderStack();
        }

        // Finally we set the base innerStack as the new stack in invContainer which is just a mutation of the stack but
        // better to set to properly update everything
        invContainer.method_5447(index(), innerStack);

        return true;
    }

    private record NestLayer(AccessoryNest accessoryNest, class_1799 holderStack, int index) {
        private boolean setInnerStack(class_1799 innerStack) {
            return accessoryNest.setInnerStack(holderStack, index, innerStack);
        }

        private class_1799 getInnerStack() {
            return accessoryNest.getInnerStacks(holderStack).get(index);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SlotPath otherPath)) return false;

        return SlotPath.areEqual(this, otherPath);
    }
}
