package io.wispforest.accessories.menu;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import io.wispforest.accessories.menu.variants.AccessoriesMenu;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import org.apache.commons.lang3.function.TriFunction;

public class AccessoriesMenuTypes {

    public static class_3917<AccessoriesMenu> PRIAMRY_MENU;

    public static void registerMenuType() {
        PRIAMRY_MENU = registerMenuType("accessories_menu_v2", AccessoriesMenu::of);
    }

    private static <T extends class_1703> class_3917<T> registerMenuType(String path, TriFunction<Integer, class_1661, AccessoriesMenuData, T> func) {
        return AccessoriesInternals.registerMenuType(Accessories.of(path), AccessoriesMenuData.ENDEC, func);
    }

//    @Environment(EnvType.CLIENT)
    public static <M extends class_1703, U extends class_437 & class_3936<M>> void registerClientMenuConstructors(MenuRegisterCallback callback) {
        callback.register(AccessoriesMenuTypes.PRIAMRY_MENU, AccessoriesScreen::new);
    }

    public interface MenuRegisterCallback {
        <M extends class_1703, U extends class_437 & class_3936<M>> void register(class_3917<? extends M> type, class_3929.class_3930<M, U> factory);
    }
}
