package io.wispforest.accessories.menu;

import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.slot.EntityBasedPredicate;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.impl.slot.StrictMode;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_10192;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1501;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Map;

public class ArmorSlotTypes implements UniqueSlotHandling.RegistrationCallback {

    private static final class_2960 SADDLE_SLOT_SPRITE = class_2960.method_60656("container/slot/saddle");

    private static final class_2960 LLAMA_ARMOR_SLOT_SPRITE = class_2960.method_60656("container/slot/llama_armor");
    private static final class_2960 HORSE_ARMOR_SLOT_SPRITE = class_2960.method_60656("container/slot/horse_armor");

    private static final Accessory armorAccessory = new Accessory() {};

    public static final Map<class_1304, class_2960> TEXTURE_EMPTY_SLOTS = Map.of(
            class_1304.field_6166, class_1723.field_21672,
            class_1304.field_6172, class_1723.field_21671,
            class_1304.field_6174, class_1723.field_21670,
            class_1304.field_6169, class_1723.field_21669,
            class_1304.field_55946, SADDLE_SLOT_SPRITE
    );

    public static final class_1304[] SLOT_IDS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};

    public static final ArmorSlotTypes INSTANCE = new ArmorSlotTypes();

    private static final class_2960 HEAD_PREDICATE_LOCATION = Accessories.of("head");
    private static final class_2960 CHEST_PREDICATE_LOCATION = Accessories.of("chest");
    private static final class_2960 LEGS_PREDICATE_LOCATION = Accessories.of("legs");
    private static final class_2960 FEET_PREDICATE_LOCATION = Accessories.of("feet");
    private static final class_2960 ANIMAL_BODY_PREDICATE_LOCATION  = Accessories.of("animal_body");
    private static final class_2960 SADDLE_PREDICATE_LOCATION  = Accessories.of("saddle");

    private SlotTypeReference headSlotReference = null;
    private SlotTypeReference chestSlotReference = null;
    private SlotTypeReference legsSlotReference = null;
    private SlotTypeReference feetSlotReference = null;
    private SlotTypeReference animalBodySlotReference = null;
    private SlotTypeReference saddleSlotReference = null;

    private ArmorSlotTypes() {}

    public static boolean isArmorType(String slotType) {
        return headSlot().slotName().equals(slotType)
                || chestSlot().slotName().equals(slotType)
                || legsSlot().slotName().equals(slotType)
                || feetSlot().slotName().equals(slotType);
    }

    public static SlotTypeReference headSlot() {
        return ArmorSlotTypes.INSTANCE.headSlotReference;
    }

    public static SlotTypeReference chestSlot() {
        return ArmorSlotTypes.INSTANCE.chestSlotReference;
    }

    public static SlotTypeReference legsSlot() {
        return ArmorSlotTypes.INSTANCE.legsSlotReference;
    }

    public static SlotTypeReference feetSlot() {
        return ArmorSlotTypes.INSTANCE.feetSlotReference;
    }

    public static SlotTypeReference animalBody() {
        return ArmorSlotTypes.INSTANCE.animalBodySlotReference;
    }

    public static SlotTypeReference saddleSlot() {
        return ArmorSlotTypes.INSTANCE.saddleSlotReference;
    }

    public static List<SlotTypeReference> getArmorReferences() {
        return List.of(headSlot(), chestSlot(), legsSlot(), feetSlot());
    }

    @Nullable
    public static class_2960 getEmptyTexture(class_1304 slot, class_1309 living) {
        var texture = TEXTURE_EMPTY_SLOTS.get(slot);

        if (texture != null) return texture;

        if (living instanceof class_1496 horse) {
            if (horse.method_56991(class_1304.field_48824)) {
                return (horse instanceof class_1501) ? LLAMA_ARMOR_SLOT_SPRITE : HORSE_ARMOR_SLOT_SPRITE;
            }
        }

        return null;
    }

    @Nullable
    public static SlotTypeReference getReferenceFromSlot(class_1304 equipmentSlot) {
        return switch (equipmentSlot) {
            case field_6169 -> headSlot();
            case field_6174 -> chestSlot();
            case field_6172 -> legsSlot();
            case field_6166 -> feetSlot();
            case field_48824 -> animalBody();
            case field_55946 -> saddleSlot();
            default -> null;
        };
    }

    public static boolean isValidEquipable(class_1304 equipmentSlot) {
        return switch (equipmentSlot) {
            case field_6169, field_6172, field_6174, field_6166, field_48824, field_55946 -> true;
            default -> false;
        };
    }

    public void init() {
        UniqueSlotHandling.EVENT.register(this);

        SlotPredicateRegistry.register(HEAD_PREDICATE_LOCATION, (EntityBasedPredicate) ((level, entity, slotType, slot, stack) -> isValid(entity, stack, class_1304.field_6169)));
        SlotPredicateRegistry.register(CHEST_PREDICATE_LOCATION, (EntityBasedPredicate) ((level, entity, slotType, slot, stack) -> isValid(entity, stack, class_1304.field_6174)));
        SlotPredicateRegistry.register(LEGS_PREDICATE_LOCATION,  (EntityBasedPredicate) ((level, entity, slotType, slot, stack) -> isValid(entity, stack, class_1304.field_6172)));
        SlotPredicateRegistry.register(FEET_PREDICATE_LOCATION,  (EntityBasedPredicate) ((level, entity, slotType, slot, stack) -> isValid(entity, stack, class_1304.field_6166)));
        SlotPredicateRegistry.register(ANIMAL_BODY_PREDICATE_LOCATION,  (EntityBasedPredicate) ((level, entity, slotType, slot, stack) -> isValid(entity, stack, class_1304.field_48824)));
        SlotPredicateRegistry.register(SADDLE_PREDICATE_LOCATION,  (EntityBasedPredicate) ((level, entity, slotType, slot, stack) -> isValid(entity, stack, class_1304.field_55946)));
    }

    @Override
    public void registerSlots(UniqueSlotHandling.UniqueSlotBuilderFactory factory) {
        headSlotReference = factory.create(Accessories.of("head"), 1)
                .allowTooltipInfo(false)
                .slotPredicates(HEAD_PREDICATE_LOCATION)
                .strictMode(StrictMode.PARTIAL)
                .allowResizing(false)
                .allowEquipFromUse(false)
                .build();

        chestSlotReference = factory.create(Accessories.of("chest"), 1)
                .allowTooltipInfo(false)
                .slotPredicates(CHEST_PREDICATE_LOCATION)
                .strictMode(StrictMode.PARTIAL)
                .allowResizing(false)
                .allowEquipFromUse(false)
                .build();

        legsSlotReference = factory.create(Accessories.of("legs"), 1)
                .allowTooltipInfo(false)
                .slotPredicates(LEGS_PREDICATE_LOCATION)
                .strictMode(StrictMode.PARTIAL)
                .allowResizing(false)
                .allowEquipFromUse(false)
                .build();

        feetSlotReference = factory.create(Accessories.of("feet"), 1)
                .allowTooltipInfo(false)
                .slotPredicates(FEET_PREDICATE_LOCATION)
                .strictMode(StrictMode.PARTIAL)
                .allowResizing(false)
                .allowEquipFromUse(false)
                .build();

        animalBodySlotReference = factory.create(Accessories.of("animal_body"), 1)
                .allowTooltipInfo(false)
                .slotPredicates(ANIMAL_BODY_PREDICATE_LOCATION)
                .strictMode(StrictMode.PARTIAL)
                .allowResizing(false)
                .allowEquipFromUse(false)
                .build();

        saddleSlotReference = factory.create(Accessories.of("saddle"), 1)
                .allowTooltipInfo(false)
                .slotPredicates(SADDLE_PREDICATE_LOCATION)
                .strictMode(StrictMode.PARTIAL)
                .allowResizing(false)
                .allowEquipFromUse(false)
                .build();
    }

    private static TriState isValid(@Nullable class_1309 livingEntity, class_1799 stack, class_1304 equipmentSlot) {
        class_1304 stackEquipmentSlot = null;

        if(livingEntity == null) {
            var equipable = stack.method_58694(class_9334.field_54196);

            if(equipable != null) stackEquipmentSlot = equipable.comp_3174();
        } else {
            stackEquipmentSlot = livingEntity.method_32326(stack);
        }

        return equipmentSlot.equals(stackEquipmentSlot) ? TriState.TRUE : TriState.DEFAULT;
    }

    @Nullable
    public static class_1799 getAlternativeStack(class_1309 instance, class_1304 equipmentSlot) {
        var capability = instance.accessoriesCapability();

        if (capability != null) {
            var reference = ArmorSlotTypes.getReferenceFromSlot(equipmentSlot);

            if (reference != null) {
                var container = capability.getContainer(reference);

                if (container != null) {
                    if(!container.shouldRender(0)) return class_1799.field_8037;

                    var stack = container.getCosmeticAccessories().method_5438(0);

                    if (!stack.method_7960() && Accessories.config().clientOptions.showCosmeticAccessories()) return stack;
                }
            }
        }

        return null;
    }
}
