package io.wispforest.accessories.menu.variants;

import I;
import Z;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.api.slot.*;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.impl.core.ExpandedContainer;
import io.wispforest.accessories.impl.option.AccessoriesPlayerOptionsHolder;
import io.wispforest.accessories.impl.option.PlayerOptions;
import io.wispforest.accessories.menu.*;
import io.wispforest.accessories.menu.networking.ToggledSlots;
import io.wispforest.owo.client.screens.SlotGenerator;
import it.unimi.dsi.fastutil.Pair;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_8181;

public class AccessoriesMenu extends AccessoriesMenuBase {

    private final Set<SlotType> usedSlots = new HashSet<>();

    private final Set<SlotGroup> selectedGroups = new HashSet<>();

    private final List<AccessoriesBasedSlot> accessoriesSpecificSlots = new ArrayList<>();

    private int addedArmorSlots = 0;

    private int startArmorSlots = 0;
    private int startingAccessoriesSlot = 0;

    public static AccessoriesMenu of(int containerId, class_1661 inventory, AccessoriesMenuData data) {
        var targetEntity = data.targetEntityId()
                .map(i -> (inventory.field_7546.method_73183().method_8469(i) instanceof class_1309 livingEntity)
                        ? livingEntity
                        : null
                ).orElse(null);

        var menu = new AccessoriesMenu(containerId, inventory, targetEntity, data.carriedStack())
                .isSyncedWithServer(data.slotAmountAdded());

        return (AccessoriesMenu) menu;
    }

    public AccessoriesMenu(int containerId, class_1661 inventory, @Nullable class_1309 targetEntity, @Nullable class_1799 carriedStack) {
        super(AccessoriesMenuTypes.PRIAMRY_MENU, containerId, inventory, 2, 2, targetEntity);

        if(carriedStack != null) this.method_34254(carriedStack);

        var accessoryTarget = targetEntity != null ? targetEntity : owner;

        var capability = AccessoriesCapability.get(accessoryTarget);

        if (capability == null) return;

        this.updateUsedSlots();

        //--

        SlotGenerator.begin(this::method_7621, -300, -300)
                .playerInventory(inventory);

        //--

        this.method_7621(new class_1735(inventory, 40, -300, -300) {
            @Override
            public void method_48931(class_1799 itemStack, class_1799 itemStack2) {
                inventory.field_7546.method_6116(class_1304.field_6171, itemStack2, itemStack);
                super.method_48931(itemStack, itemStack2);
            }

            @Override
            public class_2960 method_7679() {
                return class_1723.field_21673;
            }
        });

        //--

        this.startArmorSlots = this.field_7761.size();

        var containers = capability.getContainers();

        var validEquipmentSlots = new ArrayList<Pair<class_1304, SlotTypeReference>>();

        for (var value : class_1304.values()) {
            if (!accessoryTarget.method_56991(value)) continue;

            var armorRef = ArmorSlotTypes.getReferenceFromSlot(value);

            if (armorRef == null || containers.get(armorRef.slotName()) == null) continue;

            validEquipmentSlots.add(Pair.of(value, armorRef));
        }

        for (var pair : validEquipmentSlots.reversed()) {
            if (addArmorSlot(pair.left(), accessoryTarget, pair.right(), containers)) addedArmorSlots += 2;
        }

        this.startingAccessoriesSlot = this.field_7761.size();

        //--

        var validGroupData = SlotGroupLoader.getValidGroups(accessoryTarget);

        var slotTypes = validGroupData.values()
                .stream()
                .flatMap(Collection::stream)
                .toList();

        for (var slot : slotTypes) {
            var accessoryContainer = containers.get(slot.name());

            if (accessoryContainer == null || accessoryContainer.slotType() == null) continue;

            for (int i = 0; i < accessoryContainer.getSize(); i++) {
                var cosmeticSlot = new AccessoriesInternalSlot(accessoryContainer, true, i, -300, -300)
                        .useCosmeticIcon(false);

                this.method_7621(cosmeticSlot);
                this.accessoriesSpecificSlots.add(cosmeticSlot);

                var baseSlot = new AccessoriesInternalSlot(accessoryContainer, false, i, -300, -300);

                this.method_7621(baseSlot);
                this.accessoriesSpecificSlots.add(baseSlot);
            }
        }

        ToggledSlots.initMenu(this);

        this.slotAmountAdded = this.field_7761.size() - this.startArmorSlots;
    }

    private static class_1263 createEquipmentSlotContainer(class_1309 living, class_1304 equipmentSlot) {
        return new class_8181() {
            @Override
            public class_1799 method_54079() {
                return living.method_6118(equipmentSlot);
            }

            @Override
            public void method_54077(class_1799 item) {
                living.method_5673(equipmentSlot, item);
                if (!item.method_7960() && living instanceof class_1308 mob) {
                    mob.method_25939(equipmentSlot);
                    mob.method_5971();
                }
            }

            @Override
            public boolean method_5443(class_1657 player) {
                return player.method_5854() == living || player.method_56094(living, 4.0);
            }

            @Override public void method_5431() {}
        };
    }

    private boolean addArmorSlot(class_1304 equipmentSlot, class_1309 targetEntity, SlotTypeReference armorReference, Map<String, AccessoriesContainer> containers) {
        var location = ArmorSlotTypes.getEmptyTexture(equipmentSlot, targetEntity);

        var armorContainer = containers.get(armorReference.slotName());

        if(armorContainer == null) return false;

        var armorSlot = new AccessoriesArmorSlot(armorContainer, SlotAccessContainer.ofArmor(equipmentSlot, targetEntity), targetEntity, equipmentSlot, 0, -300, -300, location);

        this.method_7621(armorSlot);

        var cosmeticSlot = new AccessoriesInternalSlot(armorContainer, true, 0, -300, -300){
            @Override
            public @Nullable class_2960 method_7679() {
                return location;
            }
        };

        this.method_7621(cosmeticSlot);

        return true;
    }

    public final class_1309 targetEntityDefaulted() {
        var targetEntity = this.targetEntity();

        return (targetEntity != null) ? targetEntity : this.method_61631();
    }

    public int startingAccessoriesSlot() {
        return this.startArmorSlots;
    }

    public List<AccessoriesBasedSlot> getAccessoriesSlots() {
        return this.accessoriesSpecificSlots;
    }

    public List<class_1735> getVisibleAccessoriesSlots() {
        var filteredList = new ArrayList<class_1735>();

        var groups = SlotGroupLoader.getValidGroups(this.targetEntityDefaulted());

        var usedSlots = this.getUsedSlots();

        if (usedSlots != null) {
            groups.forEach((group, groupSlots) -> {
                if (groupSlots.stream().noneMatch(usedSlots::contains)) this.removeSelectedGroup(group);
            });
        }

        var selectedGroupedSlots = SlotGroupLoader.getValidGroups(this.targetEntityDefaulted()).entrySet()
                .stream()
                .filter(entry -> this.selectedGroups.isEmpty() || this.selectedGroups.contains(entry.getKey()))
                .flatMap(entry -> entry.getValue().stream())
                .toList();

        for (int i = 0; i < (this.accessoriesSpecificSlots.size() / 2); i++) {
            var cosmetic = (i * 2);
            var accessory = cosmetic + 1;

            var cosmeticSlot = this.accessoriesSpecificSlots.get(cosmetic);
            var accessorySlot = this.accessoriesSpecificSlots.get(accessory);

            var slotType = accessorySlot.slotType();

            var isVisible = (this.usedSlots.isEmpty() || this.usedSlots.contains(slotType))
                    && (selectedGroupedSlots.isEmpty() || selectedGroupedSlots.contains(slotType));

            if(isVisible){
                filteredList.add(cosmeticSlot);
                filteredList.add(accessorySlot);
            }
        }

        return filteredList;
    }

    @Nullable
    public Set<SlotType> getUsedSlots() {
        return this.areUnusedSlotsShown() ? null : this.usedSlots;
    }

    public void updateUsedSlots() {
        this.usedSlots.clear();

        if(!this.areUnusedSlotsShown()) {
            var entity = this.targetEntity != null ? this.targetEntity : this.owner;

            var currentlyUsedSlots = AccessoriesCapability.getUsedSlotsFor(entity, this.owner.method_31548());

            currentlyUsedSlots.addAll(SlotPredicateRegistry.getValidSlotTypes(entity, this.method_34255()));

            if(!currentlyUsedSlots.isEmpty()) {
                this.usedSlots.addAll(currentlyUsedSlots);
            } else {
                this.usedSlots.add(null);
            }
        }
    }

    private static Set<SlotGroup> usedGroups(class_1309 targetEntity, Set<SlotType> usedSlots) {
        var groups = SlotGroupLoader.getValidGroups(targetEntity).entrySet().stream();

        groups = groups
                .filter(entry -> {
                    var groupSlots = entry.getValue()
                            .stream()
                            .filter(slotType -> {
                                if (UniqueSlotHandling.isUniqueSlot(slotType.name())) return false;

                                var capability = targetEntity.accessoriesCapability();

                                if (capability == null) return false;

                                var container = capability.getContainer(slotType);

                                if (container == null) return false;

                                return container.getSize() > 0;
                            })
                            .collect(Collectors.toSet());

                    return !groupSlots.isEmpty() && (usedSlots == null || groupSlots.stream().anyMatch(usedSlots::contains));
                });

        return groups.map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<SlotGroup> selectedGroups() {
        return this.selectedGroups;
    }

    public boolean isGroupSelected(SlotGroup group) {
        return this.selectedGroups.contains(group);
    }

    public void toggleSelectedGroup(SlotGroup group) {
        if(isGroupSelected(group)) {
            removeSelectedGroup(group);
        } else {
            addSelectedGroup(group);
        }
    }

    public void addSelectedGroup(SlotGroup group) {
        this.selectedGroups.add(group);

        if (this.selectedGroups.containsAll(usedGroups(this.targetEntityDefaulted(), this.getUsedSlots()))) {
            this.selectedGroups.clear();
        }
    }

    public void removeSelectedGroup(SlotGroup group) {
        this.selectedGroups.remove(group);
    }

    //--

    public int addedArmorSlots() {
        return this.addedArmorSlots;
    }

    public boolean areUnusedSlotsShown() {
        return AccessoriesPlayerOptionsHolder.getOptions(owner).getDefaultedData(PlayerOptions.SHOW_UNUSED_SLOTS);
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
    }

    private int stackIndex = -1;

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        this.stackIndex = index;

        var stack = quickMoveStackInternal(player, index);

        this.stackIndex = -1;

        return stack;
    }

    private class_1799 quickMoveStackInternal(class_1657 player, int index) {
        var slot = this.field_7761.get(index);

        if(!slot.method_7681()) return class_1799.field_8037;

        var itemStack2 = slot.method_7677();
        var itemStack = itemStack2.method_7972();

        // 0 1 2 3 : 6 - 7 / 4 - 5 / 2 - 3 / 0 - 1
        var equipmentSlot = targetEntity.method_32326(itemStack);
        int bottomArmorIndex = 42 + (this.addedArmorSlots - ((equipmentSlot.method_5927() + 1) * 2));
        int topArmorIndex = bottomArmorIndex + 1;

        var upperInventorySize = this.startingAccessoriesSlot;

        /*
         * Player Indies
         *       0: Result slot
         *  1 -  5: Crafting Grid
         *  5 - 41: Player Inv
         *      41: Offhand Slot
         * 41 - (41 - 51): Armor Slots
         * (41 - 51) -   : Accessories Slots
         */

        if (index == 0) { // If from Crafting Result move to player inventory
            if (!this.method_7616(itemStack2, 5, 41, true)) return class_1799.field_8037;

            slot.method_7670(itemStack2, itemStack);
        } else if ((index >= 1 && index < 5) || (index >= upperInventorySize) || Objects.equals(41, index) || (index >= 42)) { // If from Crafting Grid move to player inventory
            if (!this.method_7616(itemStack2, 5, 41, false)) return class_1799.field_8037;
        } else if (equipmentSlot.method_46643() && !this.field_7761.get(bottomArmorIndex).method_7681()) {
            if(!this.method_7616(itemStack2, bottomArmorIndex, topArmorIndex, false)) return class_1799.field_8037;
        } else if (equipmentSlot == class_1304.field_6171 && !this.field_7761.get(41).method_7681()) {
            if(!this.method_7616(itemStack2, 41, 42, false)) return class_1799.field_8037;
        }
        else {
            boolean changeOccured = false;

            if (canMoveToAccessorySlot(itemStack2, this.targetEntityDefaulted())) {
                method_7616(itemStack2, upperInventorySize, field_7761.size(), false);

                if (itemStack2.method_7947() != itemStack.method_7947() || itemStack2.method_7960()) {
                    changeOccured = true;
                }
            }

            if(!changeOccured) {
                if (index >= 5 && index < 32) {
                    if (!this.method_7616(itemStack2, 32, 41, false)) return class_1799.field_8037;
                } else if (index >= 32 && index < 41) {
                    if (!this.method_7616(itemStack2, 5, 32, false)) return class_1799.field_8037;
                }
            }
        }

        if (itemStack2.method_7947() == itemStack.method_7947()) return class_1799.field_8037;

        if (itemStack2.method_7960()) {
            slot.method_48931(class_1799.field_8037, itemStack);
        } else {
            slot.method_7668();
        }

        if (itemStack2.method_7947() == itemStack.method_7947()) return class_1799.field_8037;

        slot.method_7667(player, itemStack2);

        if (index == 0) player.method_7328(itemStack2, false);

        return itemStack;
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return true;
    }

    protected boolean canMoveToAccessorySlot(class_1799 stack, class_1309 living) {
        var capability = living.accessoriesCapability();

        if (capability == null) return false;

        var validSlotTypes = SlotPredicateRegistry.getStackSlotTypes(living, stack);

        for (var slot : this.field_7761.subList(this.startingAccessoriesSlot, this.field_7761.size())) {
            if (slot instanceof SlotTypeAccessible accessible && validSlotTypes.contains(accessible.slotType())) return true;
        }

        return false;
    }

    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean bl = false;
        int i = reverseDirection ? endIndex - 1 : startIndex;

        if (stack.method_7946()) {
            while (!stack.method_7960() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                var slot = this.field_7761.get(i);

                if (slot.method_7682()) {
                    var itemStack = slot.method_7677();

                    if (!itemStack.method_7960() && class_1799.method_31577(stack, itemStack)) {
                        int j = itemStack.method_7947() + stack.method_7947();
                        int k = slot.method_7676(itemStack);

                        if (j <= k) {
                            stack.method_7939(0);
                            itemStack.method_7939(j);
                            slot.method_7668();
                            bl = true;

                            // PATCH TO ATTEMPT TO PRESERVE THE INDEX
                            if (stack.method_7960() && this.stackIndex != -1) {
                                var prevSlot = this.field_7761.get(this.stackIndex);

                                if (prevSlot.field_7871 instanceof ExpandedContainer simpleContainer) {
                                    simpleContainer.setPreviousItem(prevSlot.field_7874, itemStack);
                                }
                            }
                        } else if (itemStack.method_7947() < k) {
                            stack.method_7934(k - itemStack.method_7947());
                            itemStack.method_7939(k);
                            slot.method_7668();
                            bl = true;
                        }
                    }
                }

                i += (reverseDirection) ? -1 : 1;
            }
        }

        if (!stack.method_7960()) {
            i = reverseDirection ? endIndex - 1 : startIndex;

            while (reverseDirection ? i >= startIndex : i < endIndex) {
                var slot = this.field_7761.get(i);

                if(slot.method_7682()) {
                    var itemStack = slot.method_7677();

                    if (itemStack.method_7960() && slot.method_7680(stack)) {
                        int j = slot.method_7676(stack);

                        var newStack = stack.method_7971(Math.min(stack.method_7947(), j));

                        slot.method_53512(newStack);
                        slot.method_7668();

                        // PATCH TO ATTEMPT TO PRESERVE THE INDEX
                        if (stack.method_7960() && this.stackIndex != -1) {
                            var prevSlot = this.field_7761.get(this.stackIndex);

                            if (prevSlot.field_7871 instanceof ExpandedContainer simpleContainer) {
                                simpleContainer.setPreviousItem(prevSlot.method_34266(), newStack);
                            }
                        }

                        bl = true;
                        break;
                    }
                }

                i += (reverseDirection) ? -1 : 1;
            }
        }

        return bl;
    }

    //initializeContents

    // REQUIRED TO PREVENT THE MENU FROM RESETTING THE CACHE WITH STACKS THAT ARE ALREADY SYNCED TO THE CLIENT
    // SINCE ACCESSORIES CONTAINERS ARE FULLY SYNCED
    @Override
    public void method_7610(int stateId, List<class_1799> items, class_1799 carried) {
        if (!this.isValidMenu()) return;

        for(int i = 0; i < items.size(); ++i) {
            var slot = this.method_7611(i);

            if (slot instanceof SlotTypeAccessible) continue;

            slot.method_7673(items.get(i));
        }

        super.method_7610(stateId, List.of(), carried);
    }
}
