package io.wispforest.accessories.menu.variants;

import I;
import io.wispforest.accessories.menu.AccessoriesMenuVariant;
import io.wispforest.accessories.mixin.CraftingMenuAccessor;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.server.ScreenOpen;
import it.unimi.dsi.fastutil.Pair;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_5421;
import net.minecraft.class_8786;
import net.minecraft.class_9875;
import net.minecraft.class_9884;

public abstract class AccessoriesMenuBase extends class_9884 {

    protected final class_1657 owner;

    @Nullable
    protected final class_1309 targetEntity;

    protected int slotAmountAdded = -1;
    protected boolean isValid = true;

    protected AccessoriesMenuBase(class_3917<? extends AccessoriesMenuBase> menuType, int containerId, class_1661 inventory, int width, int height, @Nullable class_1309 targetEntity) {
        super(menuType, containerId, width, height);

        this.owner = inventory.field_7546;
        this.targetEntity = targetEntity;

        if (this instanceof AccessoriesMenu) {
            this.method_61625(inventory.field_7546, 154, 28);
            this.method_61626(98, 18);
        }
    }

    public final AccessoriesMenuVariant menuVariant() {
        return AccessoriesMenuVariant.getVariant((class_3917<? extends AccessoriesMenuBase>) this.method_17358());
    }

    private static final class_1735 EMPTY_SLOT = new class_1735(new class_1277(1), 0, 0, 0);

    @Override
    public class_1735 method_61627() {
        return (this instanceof AccessoriesMenu) ? this.field_7761.get(0) : EMPTY_SLOT;
    }

    @Override
    public List<class_1735> method_61628() {
        return (this instanceof AccessoriesMenu) ? this.field_7761.subList(1, 5) : List.of();
    }

    @Nullable
    public final class_1309 targetEntity() {
        return this.targetEntity;
    }

    public final class_1657 method_61631() {
        return this.owner;
    }

    public final void reopenMenu() {
        AccessoriesNetworking.sendToServer(ScreenOpen.of(this.targetEntity(), this.menuVariant()));
    }

    public void transferAndClose(Runnable setupCall) {
        setupCall.run();

        this.player().method_7346();
    }

    public int slotAmountAdded() {
        return slotAmountAdded;
    }

    public AccessoriesMenuBase isSyncedWithServer(int serverSlotAmountAdded) {
        this.isValid = slotAmountAdded == serverSlotAmountAdded;

        return this;
    }

    public boolean isValidMenu() {
        return this.isValid;
    }

    //--

    @Nullable
    public Pair<class_1799, class_1799> quickMoveStackCrafting(int index) {
        var slot = this.field_7761.get(index);

        if (slot.method_7681()) {
            var itemStack2 = slot.method_7677();
            var itemStack = itemStack2.method_7972();

            var endIndex = 5 + (4 * 9);

            if (index == 0) {
                if (!this.method_7616(itemStack2, 5, endIndex, true)) return Pair.of(class_1799.field_8037, null);

                slot.method_7670(itemStack2, itemStack);
            } else if (index >= 1 && index < 5) {
                if (!this.method_7616(itemStack2, 5, endIndex, false)) return Pair.of(class_1799.field_8037, null);
            }

            if (itemStack2.method_7947() == itemStack.method_7947()) return null;

            return Pair.of(itemStack, itemStack2);
        }

        return null;
    }

    public void method_7654(class_9875 stackedItemContents) {
        this.field_52559.method_7683(stackedItemContents);
    }

    public void clearCraftingContent() {
        this.field_52560.method_5448();
        this.field_52559.method_5448();
    }

    public boolean recipeMatches(class_8786<class_3955> recipe) {
        return recipe.comp_1933().method_8115(this.field_52559.method_59961(), this.owner.method_73183());
    }

    public void method_7609(class_1263 container) {
        if (!(this.owner.method_73183() instanceof class_3218 serverLevel)) return;

        CraftingMenuAccessor.accessories$slotChangedCraftingGrid(this, serverLevel, this.owner, this.field_52559, this.field_52560, (class_8786) null);
    }

    private class_1799 tempCarriedStack = class_1799.field_8037;

    public class_1799 getTempCarriedStack() {
        var stack = tempCarriedStack;

        this.tempCarriedStack = class_1799.field_8037;

        return stack;
    }

    public void method_7595(class_1657 player) {
        this.tempCarriedStack = this.method_34255();
        this.method_34254(class_1799.field_8037);

        super.method_7595(player);
        this.field_52560.method_5448();
        if (!player.method_73183().method_8608()) {
            this.method_7607(player, this.field_52559);
        }
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot.field_7871 != this.field_52560 && super.method_7613(stack, slot);
    }

    public int getResultSlotIndex() {
        return -1;
    }

    public int method_61629() {
        return this.field_52559.method_17398();
    }

    public int method_61630() {
        return this.field_52559.method_17397();
    }

    public int getSize() {
        return this.field_52559.method_17398() * this.field_52559.method_17397() + 1;
    }

    public class_5421 method_30264() {
        return class_5421.field_25763;
    }
}
