package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import io.wispforest.accessories.pond.EnchantedItemInUseExtension;
import io.wispforest.owo.Owo;
import it.unimi.dsi.fastutil.objects.Object2IntMap.Entry;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.*;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9699;
import net.minecraft.server.MinecraftServer;

@Mixin(class_1890.class)
public abstract class EnchantmentHelperMixin {

    @Shadow
    protected static void runIterationOnItem(class_1799 itemStack, class_1304 equipmentSlot, class_1309 livingEntity, class_1890.class_9702 enchantmentInSlotVisitor) {}

    @WrapOperation(method = "getEnchantmentLevel", at = @At(value = "INVOKE", target = "Ljava/util/Map;values()Ljava/util/Collection;"))
    private static Collection<class_1799> addAccessoriesStacks(Map instance, Operation<Collection<class_1799>> original, @Local(argsOnly = true) class_6880<class_1887> enchantment, @Local(argsOnly = true) class_1309 entity){
        var returnValue = new ArrayList<>(original.call(instance));

        //if(Accessories.enchantmentValidForRedirect(enchantment)) {
        var capability = entity.accessoriesCapability();

        if(capability != null) {
            returnValue.addAll(capability.getAllEquipped().stream().map(SlotEntryReference::stack).toList());
        }
        //}

        return returnValue;
    }

//    @ModifyReturnValue(method = "getEnchantmentLevel", at = @At(value = "RETURN"))
//    private static int adjustEnchantmentLevel(int original, @Local(argsOnly = true) LivingEntity livingEntity, @Local(argsOnly = true) Holder<Enchantment> holder){
//        var enchantments = livingEntity.registryAccess().registry(Registries.ENCHANTMENT).orElseThrow();
//
//        if(enchantments.getResourceKey(holder.value()).orElseThrow().equals(Enchantments.LOOTING)){
//            ExtraEventHandler.lootingAdjustments(livingEntity, , value)
//        }
//
//        return original;
//    }

    @Inject(method = "getRandomItemWith", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;getRandom()Lnet/minecraft/util/RandomSource;"))
    private static void adjustListForAccessories(class_9331<?> dataComponentType, class_1309 livingEntity, Predicate<class_1799> predicate, CallbackInfoReturnable<Optional<class_9699>> cir, @Local(ordinal = 0) List<class_9699> list) {
        var capability = livingEntity.accessoriesCapability();

        if(capability != null){
            var allEquippedAccessories = capability
                    .getAllEquipped()
                    .stream()
                    .filter(entryReference -> {
                        var itemStack = entryReference.stack();

                        if(predicate.test(entryReference.stack())) {
                            class_9304 itemEnchantments = itemStack.method_58695(class_9334.field_49633, class_9304.field_49385);

                            for(var entry : itemEnchantments.method_57539()) {
                                var holder = entry.getKey();

                                if (holder.comp_349().comp_2689().method_57832(dataComponentType)) { //((Enchantment)holder.value()).matchingSlot(equipmentSlot)
                                    var valid = enchantmentValidForRedirect(livingEntity.method_56673(), holder.comp_349());

                                    if(valid != null) return valid;
                                }
                            }
                        }

                        return false;
                    }).map(entryReference -> {
                        return ((EnchantedItemInUseExtension) (Object) new class_9699(entryReference.stack(), AccessoriesInternals.INTERNAL_SLOT, livingEntity, item -> entryReference.reference().breakStack()))
                                .setSlotReference(entryReference.reference());
                    })
                    .toList();

            list.addAll(allEquippedAccessories);
        }
    }

    @Inject(method = "runIterationOnEquipment", at = @At("TAIL"))
    private static void adjustIterationWithAccessories(class_1309 livingEntity, class_1890.class_9702 enchantmentInSlotVisitor, CallbackInfo ci) {
        var capability = livingEntity.accessoriesCapability();

        if(capability != null){
            capability.getAllEquipped()
                    .forEach(entryReference -> {
                        var itemStack = entryReference.stack();

                        ((AccessoriesLivingEntityExtension) livingEntity).pushEnchantmentContext(itemStack, entryReference.reference());
                        runIterationOnItem(itemStack, AccessoriesInternals.INTERNAL_SLOT, livingEntity, enchantmentInSlotVisitor);
                    });
        }
    }

    @WrapMethod(method = "runIterationOnItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentVisitor;)V")
    private static void unpackAccessoryNest1(class_1799 stack, class_1890.class_1891 visitor, Operation<Void> original) {
        original.call(stack, visitor);

        AccessoryNestUtils.recursiveStackConsumption(stack, innerStack -> original.call(innerStack, visitor));
    }

    @WrapMethod(method = "runIterationOnItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentInSlotVisitor;)V")
    private static void unpackAccessoryNest2(class_1799 stack, class_1304 slot, class_1309 entity, class_1890.class_9702 visitor, Operation<Void> original) {
        original.call(stack, slot, entity, visitor);

        AccessoryNestUtils.recursiveStackConsumption(stack, innerStack -> original.call(stack, slot, entity, visitor));
    }

    @ModifyExpressionValue(
            method = "runIterationOnItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentInSlotVisitor;)V",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/enchantment/Enchantment;matchingSlot(Lnet/minecraft/world/entity/EquipmentSlot;)Z")
    )
    private static boolean adjustIfIterationOccurs(boolean original, @Local(argsOnly = true) class_1304 equipmentSlot, @Local(argsOnly = true) class_1309 livingEntity, @Local(ordinal = 0) class_6880<class_1887> holder) {
        if(equipmentSlot.equals(AccessoriesInternals.INTERNAL_SLOT)) {
            var valid = enchantmentValidForRedirect(livingEntity.method_56673(), holder.comp_349());

            if(valid != null) return valid;
        }

        return original;
    }

    @WrapOperation(
            method = "runIterationOnItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentInSlotVisitor;)V",
            at = @At(value = "NEW", target = "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/enchantment/EnchantedItemInUse;")
    )
    private static class_9699 addSlotReferenceToEnchantRecord(class_1799 itemStack, class_1304 inSlot, class_1309 owner, Operation<class_9699> original) {
        class_9699 record = null;

        if (inSlot.equals(AccessoriesInternals.INTERNAL_SLOT)) {
            var ref = ((AccessoriesLivingEntityExtension) owner).popEnchantmentContext(itemStack);

            if (ref != null) {
                record = new class_9699(itemStack, inSlot, owner, item -> ref.breakStack());

                ((EnchantedItemInUseExtension)(Object) record).setSlotReference(ref);
            }
        }

        if (record == null) record = original.call(itemStack, inSlot, owner);

        return record;
    }

    @WrapOperation(method = "method_60148", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/enchantment/Enchantment;matchingSlot(Lnet/minecraft/world/entity/EquipmentSlot;)Z"))
    private static boolean allowAccessoriesSlotEnchentments(class_1887 instance, class_1304 slot, Operation<Boolean> original) {
        if (slot.equals(AccessoriesInternals.INTERNAL_SLOT)) {
            var valid = enchantmentValidForRedirect(null, instance);

            if(valid != null) return valid;
        }

        return original.call(instance, slot);
    }

    @Unique
    @Nullable
    private static Boolean enchantmentValidForRedirect(@Nullable class_5455 access, class_1887 enchantment) {
        class_2378<class_1887> enchantments;

        if (access != null) {
            enchantments = access.method_30530(class_7924.field_41265);
        } else {
            // THIS IS VERY CRING BUT LACKING CONTEXT MEANS NOT MUCH CAN BE DONE
            var server = Owo.currentServer();

            if (server != null) {
                enchantments = server.method_30611().method_30530(class_7924.field_41265);
            } else {
                return null;
            }
        }

        return !enchantments.method_46746(enchantments.method_29113(enchantment).orElseThrow())
                .orElseThrow()
                .method_40220(AccessoriesTags.INVALID_FOR_REDIRECTION);
    }
}
