package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import io.wispforest.accessories.pond.EnchantedItemInUseExtension;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.class_9699;
import net.minecraft.class_9722;

@Mixin(class_1887.class)
public abstract class EnchantmentMixin {

    @Inject(method = "runLocationChangedEffects", at = @At("HEAD"), cancellable = true)
    private void failSafeForInvalidRecordObjects1(class_3218 level, int enchantmentLevel, class_9699 item, class_1309 entity, CallbackInfo ci) {
        if(item.comp_2683() == AccessoriesInternals.INTERNAL_SLOT) {
            var ref = ((EnchantedItemInUseExtension) (Object) item).getSlotReference();

            if (ref == null) ci.cancel();
        }
    }

    @Inject(method = "stopLocationBasedEffects", at = @At("HEAD"), cancellable = true)
    private void failSafeForInvalidRecordObjects2(int enchantmentLevel, class_9699 item, class_1309 entity, CallbackInfo ci) {
        if(item.comp_2683() == AccessoriesInternals.INTERNAL_SLOT) {
            var ref = ((EnchantedItemInUseExtension) (Object) item).getSlotReference();

            if (ref == null) ci.cancel();
        }
    }

    @WrapOperation(method = "runLocationChangedEffects", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/enchantment/Enchantment;matchingSlot(Lnet/minecraft/world/entity/EquipmentSlot;)Z"))
    private boolean checkIfEnchantmentValid(class_1887 instance, class_1304 slot, Operation<Boolean> original, @Local(argsOnly = true) class_3218 level){
        return slot.equals(AccessoriesInternals.INTERNAL_SLOT)
                ? original.call(instance, slot)
                : enchantmentValidForRedirect(level.method_30349(), instance);
    }

    @WrapOperation(method = {
            "runLocationChangedEffects",
            "stopLocationBasedEffects"
    }, at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;activeLocationDependentEnchantments(Lnet/minecraft/world/entity/EquipmentSlot;)Ljava/util/Map;"))
    private Map<class_1887, Set<class_9722>> adjustMapLookupForRecord(class_1309 instance, class_1304 slot, Operation<Map<class_1887, Set<class_9722>>> original, @Local(argsOnly = true) class_9699 item) {
        if (slot.equals(AccessoriesInternals.INTERNAL_SLOT)) {
            var ref = ((EnchantedItemInUseExtension) (Object) item).getSlotReference();

            return (ref != null)
                    ? ((AccessoriesLivingEntityExtension) instance).activeLocationDependentEnchantmentsFromSlotReference(ref)
                    : new HashMap<>();
        }

        return original.call(instance, slot);
    }

    @Unique
    private static boolean enchantmentValidForRedirect(class_5455 access, class_1887 enchantment) {
        var enchantments = access.method_30530(class_7924.field_41265);

        return !enchantments.method_46746(enchantments.method_29113(enchantment).orElseThrow())
                .orElseThrow()
                .method_40220(AccessoriesTags.INVALID_FOR_REDIRECTION);
    }
}
