package io.wispforest.accessories.mixin;

import io.wispforest.accessories.pond.ContextedFileToIdConverter;
import org.spongepowered.asm.mixin.Mixin;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_7654;

@Mixin(class_7654.class)
public abstract class FileToIdConverterMixin implements ContextedFileToIdConverter {

    private Map<class_2960, Object> contextData = new HashMap<>();

    @Override
    public <T> class_7654 setData(class_2960 location, T t) {
        contextData.put(location, t);

        return (class_7654) (Object) this;
    }

    @Override
    public <T> T getData(class_2960 location) {
        return (T) contextData.get(location);
    }
}
