package io.wispforest.accessories.mixin;

import Z;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.caching.ItemStackBasedPredicate;
import io.wispforest.accessories.api.core.Accessory;
import io.wispforest.accessories.api.core.AccessoryRegistry;
import io.wispforest.accessories.api.events.extra.ExtraEventHandler;
import io.wispforest.accessories.api.events.extra.OnTotemActivate;
import io.wispforest.accessories.api.events.extra.OnTotemConsumption;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotPredicateRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.core.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.core.AccessoriesHolderImpl;
import io.wispforest.accessories.pond.AccessoriesAPIAccess;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_10192;
import net.minecraft.class_10216;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5712;
import net.minecraft.class_9334;
import net.minecraft.class_9722;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 implements AccessoriesAPIAccess, AccessoriesLivingEntityExtension {

    @Shadow public abstract void swing(class_1268 hand, boolean updateSelf);

    @Unique
    private AccessoriesCapabilityImpl accessories$capability = null;

    @Unique
    private final Map<class_1799, SlotReference> accessories$enchantmentLocationContext = new Reference2ObjectOpenHashMap<>();

    @Unique
    private final Map<String, Reference2ObjectMap<class_1887, Set<class_9722>>> accessories$activeLocationDependentEnchantments = new HashMap<>();

    protected LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    public AccessoriesCapability getOrCreateAccessoriesCapability() {
        if (accessories$capability == null) {
            this.accessories$capability = new AccessoriesCapabilityImpl((class_1309) (Object) this);
        }

        return accessories$capability;
    }

    @Override
    @Nullable
    public AccessoriesCapability accessoriesCapability() {
        var slots = EntitySlotLoader.getEntitySlots((class_1309) (Object) this);

        if(slots.isEmpty()) return null;

        var capability = getOrCreateAccessoriesCapability();

        // Used to init some functions behind the scene
        AccessoriesHolderImpl.getHolder(capability);

        return capability;
    }

    @Override
    public void pushEnchantmentContext(class_1799 stack, SlotReference reference) {
        this.accessories$enchantmentLocationContext.put(stack, reference);
    }

    @Override
    @Nullable
    public SlotReference popEnchantmentContext(class_1799 stack) {
        return this.accessories$enchantmentLocationContext.remove(stack);
    }

    @Override
    public Map<class_1887, Set<class_9722>> activeLocationDependentEnchantmentsFromSlotReference(SlotReference slotReference) {
        return accessories$activeLocationDependentEnchantments.computeIfAbsent(slotReference.createString(), equipmentSlot -> new Reference2ObjectArrayMap());
    }

    //--

    @Inject(method = "onEquippedItemBroken", at = @At("HEAD"), cancellable = true)
    private void sendAccessoriesBreakInstead(class_1792 item, class_1304 slot, CallbackInfo ci){
        if(slot.equals(AccessoriesInternals.INTERNAL_SLOT)) ci.cancel();
    }

    @Inject(method = "entityEventForEquipmentBreak", at = @At("HEAD"), cancellable = true)
    private static void preventMatchExceptionForAccessories(class_1304 slot, CallbackInfoReturnable<Byte> cir) {
        if(slot.equals(AccessoriesInternals.INTERNAL_SLOT)) cir.setReturnValue((byte) -1);
    }

    public void onEquipItem(SlotReference slotReference, class_1799 oldItem, class_1799 newItem) {
        var level = this.method_73183();

        if (!class_1799.method_31577(oldItem, newItem) && !this.field_5953 && !level.method_8608() && !this.method_7325()) {
            var isEquitableFor = newItem.method_7960() || SlotPredicateRegistry.canInsertIntoSlot(newItem, slotReference);

            if (!this.method_5701() && !newItem.method_7960()) {
                var sound = AccessoryRegistry.getAccessoryOrDefault(newItem).getEquipSound(newItem, slotReference);

                if(sound != null) level.method_47967(null, this.method_23317(), this.method_23318(), this.method_23321(), sound.event().comp_349(), this.method_5634(), sound.volume(), sound.pitch(), this.field_5974.method_43055());
            }

            if (isEquitableFor) this.method_32876(!newItem.method_7960() ? class_5712.field_28739 : class_5712.field_45787);
        }
    }

    //--

    @Inject(method = "isLookingAtMe", at = @At("HEAD"), cancellable = true)
    private void accessories$isGazeDisguised(class_1309 livingEntity, double tolerance, boolean scaleByDistance, boolean visual, double[] yValues, CallbackInfoReturnable<Boolean> cir) {
        var state = ExtraEventHandler.isGazedBlocked((class_1309) (Object) this, livingEntity);

        if (state != TriState.DEFAULT) cir.setReturnValue(!state.get());
    }

    //--

    @ModifyReturnValue(method = "canFreeze", at = @At(value = "RETURN", ordinal = 1))
    private boolean canFreezeAccessoriesCheck(boolean bl) {
        var state = ExtraEventHandler.canFreezeEntity((class_1309) (Object) this);

        return state.orElse(bl);
    }

    //--

    @Inject(method = "checkTotemDeathProtection", at = @At(value = "JUMP", opcode = Opcodes.IFNULL, ordinal = 1, shift = At.Shift.BEFORE))
    private void accessories$checkForTotems(class_1282 damageSource, CallbackInfoReturnable<Boolean> cir, @Local(ordinal = 0) LocalRef<class_1799> itemStack, @Local(ordinal = 0) LocalRef<class_10216> deathProtection, @Share(value = "currentSlotReference") LocalRef<@Nullable SlotReference> currentSlotReference) {
        var capability = this.accessoriesCapability();

        SlotReference slotReference = null;

        if (capability != null && deathProtection.get() == null) {
            var totem = capability.getFirstEquipped(ItemStackBasedPredicate.ofComponents("totem_check", class_9334.field_54274));

            if (totem != null) {
                slotReference = totem.reference();

                var totemStack = totem.stack();

                itemStack.set(totemStack.method_7972());
                deathProtection.set(totemStack.method_58694(class_9334.field_54274));
                // TODO: SHOULD BE CONFIGURABLE IF SUCH GETS CONSUMED?

                var accessory = AccessoryRegistry.getAccessoryOrDefault(totemStack);

                var consumptionAction = (accessory instanceof OnTotemConsumption onTotemConsumption)
                        ? onTotemConsumption
                        : OnTotemConsumption.DEFAULT_BEHAVIOR;

                totemStack = consumptionAction.onConsumption(slotReference, totemStack, damageSource);

                slotReference.setStack(totemStack);
            }
        }

        currentSlotReference.set(slotReference);
    }

    @WrapOperation(method = "checkTotemDeathProtection", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/component/DeathProtection;applyEffects(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)V"))
    private void accessories$adjustTotemEffects(class_10216 instance, class_1799 itemStack, class_1309 livingEntity, Operation<Void> original, @Local(argsOnly = true) class_1282 damageSource, @Share(value = "currentSlotReference") LocalRef<@Nullable SlotReference> currentSlotReference) {
        var slotReference = currentSlotReference.get();

        if (slotReference != null) {
            var accessory = AccessoryRegistry.getAccessoryOrDefault(itemStack);

            var activationAction = (accessory instanceof OnTotemActivate onTotemActivate)
                    ? onTotemActivate
                    : OnTotemActivate.DEFAULT_BEHAVIOR;

            instance = activationAction.onActivation(instance, slotReference, itemStack, damageSource);

            if (instance == null) return;
        }

        original.call(instance, itemStack, livingEntity);
    }

    //--

    @WrapOperation(method = "updateFallFlying", at = @At(value = "INVOKE", target = "Ljava/util/stream/Stream;toList()Ljava/util/List;"))
    private List<class_1304> accessories$addEquipmentCheck(Stream<class_1304> instance, Operation<List<class_1304>> original, @Share("slotReference") LocalRef<@Nullable SlotReference> slotReference) {
        var capability = this.accessoriesCapability();

        slotReference.set(null);

        if (capability != null) {
            var gliders = capability.getEquipped(ItemStackBasedPredicate.ofComponents(class_9334.field_54197));

            if (!gliders.isEmpty()) {
                var glider = class_156.method_32309(gliders, this.field_5974);

                if (class_1309.method_63624(glider.stack(), AccessoriesInternals.INTERNAL_SLOT)) {
                    slotReference.set(glider.reference());

                    instance = Stream.concat(instance, Stream.of(AccessoriesInternals.INTERNAL_SLOT));
                }
            }
        }

        return original.call(instance);
    }

    @WrapOperation(method = "updateFallFlying", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;getItemBySlot(Lnet/minecraft/world/entity/EquipmentSlot;)Lnet/minecraft/world/item/ItemStack;"))
    private class_1799 accessories$adjustGottenStack(class_1309 instance, class_1304 equipmentSlot, Operation<class_1799> original, @Share("slotReference") LocalRef<@Nullable SlotReference> slotReference) {
        if (equipmentSlot != AccessoriesInternals.INTERNAL_SLOT) return original.call(instance, equipmentSlot);

        var stack = slotReference.get().getStack();

        return stack != null ? stack : class_1799.field_8037;
    }

    @WrapOperation(method = "updateFallFlying", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/EquipmentSlot;)V"))
    private void accessories$adjustHurtAndBreak(class_1799 instance, int amount, class_1309 entity, class_1304 slot, Operation<Void> original, @Share("slotReference") LocalRef<@Nullable SlotReference> slotReference) {
        var ref = slotReference.get();

        if (ref == null) {
            original.call(instance, amount, entity, slot);
        } else if(entity.method_73183() instanceof class_3218 serverLevel) {
            instance.method_7956(amount, serverLevel, entity instanceof class_3222 serverPlayer ? serverPlayer : null, item -> ref.breakStack());
        }
    }

    @Inject(method = "canGlide", at = @At(value = "FIELD", target = "Lnet/minecraft/world/entity/EquipmentSlot;VALUES:Ljava/util/List;"), cancellable = true)
    private void accessories$checkAccessoriesGliders(CallbackInfoReturnable<Boolean> cir) {
        var capability = this.accessoriesCapability();

        if (capability == null) return;

        var gliders = capability.getEquipped(ItemStackBasedPredicate.ofComponents(class_9334.field_54197));

        if (gliders.isEmpty()) return;

        for (var glider : gliders) {
            if (class_1309.method_63624(glider.stack(), AccessoriesInternals.INTERNAL_SLOT)) {
                cir.setReturnValue(true);
            }
        }
    }

    @WrapOperation(method = "canGlideUsing", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/equipment/Equippable;slot()Lnet/minecraft/world/entity/EquipmentSlot;"))
    private static class_1304 accessories$changeEquipmentSlot(class_10192 instance, Operation<class_1304> original, @Local(argsOnly = true) class_1304 equipmentSlot) {
        return (equipmentSlot == AccessoriesInternals.INTERNAL_SLOT) ? AccessoriesInternals.INTERNAL_SLOT : original.call(instance);
    }
}
