package io.wispforest.accessories.mixin;

import io.wispforest.accessories.api.events.extra.ExtraEventHandler;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1309;
import net.minecraft.class_4838;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_4838.class)
public abstract class PiglinAiMixin {

    @Inject(method = "isWearingSafeArmor", at = @At("HEAD"), cancellable = true)
    private static void isWearingGoldAccessory(class_1309 livingEntity, CallbackInfoReturnable<Boolean> cir){
        var state = ExtraEventHandler.isPiglinsNeutral(livingEntity);

        if(state != TriState.DEFAULT) cir.setReturnValue(state.orElse(false));
    }
}
