package io.wispforest.accessories.mixin;

import io.wispforest.accessories.api.events.extra.ExtraEventHandler;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_5635;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_5635.class)
public abstract class PowderSnowBlockMixin {

    @Inject(method = "canEntityWalkOnPowderSnow", at = @At("HEAD"), cancellable = true)
    private static void adjustSnowWalkingAbility(class_1297 entity, CallbackInfoReturnable<Boolean> cir){
        if(entity instanceof class_1309 livingEntity){
            var state = ExtraEventHandler.allowWalkingOnSnow(livingEntity);

            if(state != TriState.DEFAULT) cir.setReturnValue(state.orElse(false));
        }
    }
}
