package io.wispforest.accessories.mixin;

import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.pond.ContextedFileToIdConverter;
import io.wispforest.accessories.pond.ReplaceableJsonResourceReloadListener;
import io.wispforest.accessories.utils.JsonUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4309;
import net.minecraft.class_7654;

@Mixin(class_4309.class)
public abstract class SimpleJsonResourceReloadListenerMixin implements ReplaceableJsonResourceReloadListener {
    @Unique
    private boolean allowReplacementLoading = false;

    @Override
    public void accessories$allowReplacementLoading(boolean value) {
        this.allowReplacementLoading = value;
    }

    @Override
    public boolean accessories$allowReplacementLoading() {
        return this.allowReplacementLoading;
    }

    @WrapOperation(method = "prepare(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)Ljava/util/Map;", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/packs/resources/SimpleJsonResourceReloadListener;scanDirectory(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/resources/FileToIdConverter;Lcom/mojang/serialization/DynamicOps;Lcom/mojang/serialization/Codec;Ljava/util/Map;)V"))
    private <T> void checkIfReplaceScan(class_3300 resourceManager, class_7654 converter, DynamicOps<JsonElement> ops, Codec<T> codec, Map<class_2960, T> output, Operation<Void> original) {
        // TODO: REPLACE WITH INJECTION INTO ORIGINAL SCAN??

        if (this.allowReplacementLoading) {
            converter = ((ContextedFileToIdConverter) converter)
                    .setData(Accessories.of("allow_replacement_loading"), true);
        }

        original.call(resourceManager, converter, ops, codec, output);
    }

    @WrapOperation(method = "scanDirectory(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/resources/FileToIdConverter;Lcom/mojang/serialization/DynamicOps;Lcom/mojang/serialization/Codec;Ljava/util/Map;)V",
    at = @At(value = "INVOKE", target = "Lnet/minecraft/resources/FileToIdConverter;listMatchingResources(Lnet/minecraft/server/packs/resources/ResourceManager;)Ljava/util/Map;"))
    private static Map<class_2960, class_3298> listReplacedResources(class_7654 instance, class_3300 resourceManager, Operation<Map<class_2960, class_3298>> original) {
        if (instance instanceof ContextedFileToIdConverter ctx && ctx.<Boolean>getDataOrDefault(Accessories.of("allow_replacement_loading"), false)) {
            return JsonUtils.scanDirectoryWithReplace(resourceManager, instance);
        }

        return original.call(instance, resourceManager);
    }
}
